/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.temporal.simpleTemporal;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.temporal.simpleTemporal.SimpleTemporalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapper
extends SimpleTemporalMapper {
    protected static final Logger logger = LoggerFactory.getLogger(ConcurrentMapper.class);

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        Parser p = new Parser(expression, threshold);
        TreeMap<String, Set<Instance>> sources = this.orderByBeginDate(source, expression, "source");
        TreeMap<String, Set<Instance>> targets = this.orderByBeginDate(target, expression, "target");
        String machineIDSource = this.getSecondProperty(p.getLeftTerm());
        String machineIDTarget = this.getSecondProperty(p.getRightTerm());
        for (Map.Entry<String, Set<Instance>> sourceEntry : sources.entrySet()) {
            String epochSource = sourceEntry.getKey();
            Set<Instance> targetInstances = targets.get(epochSource);
            if (targetInstances == null) continue;
            Set<Instance> sourceInstances = sourceEntry.getValue();
            for (Instance i : sourceInstances) {
                for (Instance j : targetInstances) {
                    if (!i.getProperty(machineIDSource).equals(j.getProperty(machineIDTarget))) continue;
                    m.add(i.getUri(), j.getUri(), 1.0);
                }
            }
        }
        return m;
    }

    @Override
    public String getName() {
        return "Concurrent";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }
}

