/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.AllenAlgebraMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.atomic.BeginBegin;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.atomic.EndEnd;

public class DuringMapper
extends AllenAlgebraMapper {
    public DuringMapper() {
        this.getRequiredAtomicRelations().add(7);
        this.getRequiredAtomicRelations().add(0);
        this.getRequiredAtomicRelations().add(1);
    }

    @Override
    public String getName() {
        return "During";
    }

    @Override
    public AMapping getMapping(ArrayList<TreeMap<String, Set<String>>> maps) {
        AMapping m = MappingFactory.createDefaultMapping();
        TreeMap<String, Set<String>> mapEE1 = maps.get(0);
        TreeMap<String, Set<String>> mapBB0 = maps.get(1);
        TreeMap<String, Set<String>> mapBB1 = maps.get(2);
        for (Map.Entry<String, Set<String>> entryEE1 : mapEE1.entrySet()) {
            Set<String> union;
            Set<String> difference;
            String instanceEE1 = entryEE1.getKey();
            Set<String> setEE1 = entryEE1.getValue();
            Set<String> setBB0 = mapBB0.get(instanceEE1);
            Set<String> setBB1 = mapBB1.get(instanceEE1);
            if (setBB0 == null) {
                setBB0 = new TreeSet<String>();
            }
            if (setBB1 == null) {
                setBB1 = new TreeSet<String>();
            }
            if ((difference = AllenAlgebraMapper.difference(setEE1, union = AllenAlgebraMapper.union(setBB0, setBB1))).isEmpty()) continue;
            for (String targetInstanceUri : difference) {
                m.add(instanceEE1, targetInstanceUri, 1.0);
            }
        }
        return m;
    }

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        ArrayList<TreeMap<String, Set<String>>> maps = new ArrayList<TreeMap<String, Set<String>>>();
        EndEnd ee = new EndEnd();
        BeginBegin bb = new BeginBegin();
        maps.add(ee.getPredecessorEvents(source, target, expression));
        maps.add(bb.getConcurrentEvents(source, target, expression));
        maps.add(bb.getPredecessorEvents(source, target, expression));
        AMapping m = this.getMapping(maps);
        return m;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }
}

