/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.AllenAlgebraMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.atomic.BeginEnd;

public class AfterMapper
extends AllenAlgebraMapper {
    ACache source;
    ACache target;

    public AfterMapper() {
        this.getRequiredAtomicRelations().add(2);
        this.getRequiredAtomicRelations().add(3);
    }

    @Override
    public String getName() {
        return "After";
    }

    @Override
    public AMapping getMapping(ArrayList<TreeMap<String, Set<String>>> maps) {
        AMapping m = MappingFactory.createDefaultMapping();
        TreeMap<String, Set<String>> mapBE0 = maps.get(0);
        TreeMap<String, Set<String>> mapBE1 = maps.get(1);
        HashSet<String> sources = new HashSet<String>();
        sources.addAll(this.source.getAllUris());
        HashSet<String> targets = new HashSet<String>();
        targets.addAll(this.target.getAllUris());
        for (String sourceInstance : sources) {
            Set<String> union;
            Set<String> difference;
            Set<String> setBE0 = mapBE0.get(sourceInstance);
            Set<String> setBE1 = mapBE1.get(sourceInstance);
            if (setBE0 == null) {
                setBE0 = new TreeSet<String>();
            }
            if (setBE1 == null) {
                setBE1 = new TreeSet<String>();
            }
            if ((difference = AllenAlgebraMapper.difference(targets, union = AllenAlgebraMapper.union(setBE0, setBE1))).isEmpty()) continue;
            for (String targetInstanceUri : difference) {
                m.add(sourceInstance, targetInstanceUri, 1.0);
            }
        }
        return m;
    }

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        this.source = source;
        this.target = target;
        ArrayList<TreeMap<String, Set<String>>> maps = new ArrayList<TreeMap<String, Set<String>>>();
        BeginEnd be = new BeginEnd();
        maps.add(be.getConcurrentEvents(source, target, expression));
        maps.add(be.getPredecessorEvents(source, target, expression));
        AMapping m = this.getMapping(maps);
        return m;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }
}

