/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.atomic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAtomicAllenAlgebraMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AAtomicAllenAlgebraMapper.class);

    protected static String getBeginProperty(String expression) {
        expression = expression.substring(expression.indexOf(".") + 1, expression.length());
        int plusIndex = expression.indexOf("|");
        if (expression.indexOf("|") != -1) {
            String p1 = expression.substring(0, plusIndex);
            return p1;
        }
        return expression;
    }

    protected static String getEndProperty(String expression) throws IllegalArgumentException {
        expression = expression.substring(expression.indexOf(".") + 1, expression.length());
        int plusIndex = expression.indexOf("|");
        if (expression.indexOf("|") != -1) {
            String p1 = expression.substring(plusIndex + 1, expression.length());
            return p1;
        }
        throw new IllegalArgumentException();
    }

    protected static TreeMap<Long, Set<String>> orderByBeginDate(ACache cache, String expression, String kbType) {
        TreeMap<Long, Set<String>> blocks = new TreeMap<Long, Set<String>>();
        Parser p = new Parser(expression, 1.0);
        String property = null;
        property = kbType.equalsIgnoreCase("source") ? AAtomicAllenAlgebraMapper.getBeginProperty(p.getLeftTerm()) : AAtomicAllenAlgebraMapper.getBeginProperty(p.getRightTerm());
        for (Instance instance : cache.getAllInstances()) {
            TreeSet<String> time = instance.getProperty(property);
            for (String value : time) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
                    Date date = df.parse(value);
                    long epoch = date.getTime();
                    if (!blocks.containsKey(epoch)) {
                        HashSet<String> l = new HashSet<String>();
                        l.add(instance.getUri());
                        blocks.put(epoch, l);
                        continue;
                    }
                    blocks.get(epoch).add(instance.getUri());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return blocks;
    }

    protected static TreeMap<Long, Set<String>> orderByEndDate(ACache cache, String expression, String kbType) {
        TreeMap<Long, Set<String>> blocks = new TreeMap<Long, Set<String>>();
        Parser p = new Parser(expression, 1.0);
        String property = null;
        property = kbType.equalsIgnoreCase("source") ? AAtomicAllenAlgebraMapper.getEndProperty(p.getLeftTerm()) : AAtomicAllenAlgebraMapper.getEndProperty(p.getRightTerm());
        for (Instance instance : cache.getAllInstances()) {
            TreeSet<String> time = instance.getProperty(property);
            for (String value : time) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
                    Date date = df.parse(value);
                    long epoch = date.getTime();
                    if (!blocks.containsKey(epoch)) {
                        HashSet<String> l = new HashSet<String>();
                        l.add(instance.getUri());
                        blocks.put(epoch, l);
                        continue;
                    }
                    blocks.get(epoch).add(instance.getUri());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return blocks;
    }

    protected static TreeMap<String, Set<String>> mapConcurrent(TreeMap<Long, Set<String>> sources, TreeMap<Long, Set<String>> targets) {
        TreeMap<String, Set<String>> concurrentEvents = new TreeMap<String, Set<String>>();
        for (Map.Entry<Long, Set<String>> sourceEntry : sources.entrySet()) {
            Long sourceTimeStamp = sourceEntry.getKey();
            Set<String> sourceInstances = sourceEntry.getValue();
            Set<String> tempTargets = targets.get(sourceTimeStamp);
            if (tempTargets == null) continue;
            for (String sourceInstance : sourceInstances) {
                concurrentEvents.put(sourceInstance, tempTargets);
            }
        }
        return concurrentEvents;
    }

    protected static TreeMap<String, Set<String>> mapPredecessor(TreeMap<Long, Set<String>> sources, TreeMap<Long, Set<String>> targets) {
        TreeMap<String, Set<String>> concurrentEvents = new TreeMap<String, Set<String>>();
        for (Map.Entry<Long, Set<String>> sourceEntry : sources.entrySet()) {
            Long sourceTimeStamp = sourceEntry.getKey();
            Set<String> sourceInstances = sourceEntry.getValue();
            SortedMap<Long, Set<String>> tempTargets = targets.tailMap(sourceTimeStamp);
            if (tempTargets == null) continue;
            TreeSet subTargets = new TreeSet();
            for (Map.Entry<Long, Set<String>> targetEntry : tempTargets.entrySet()) {
                Long targetTimeStamp = targetEntry.getKey();
                if (targetTimeStamp.equals(sourceTimeStamp)) continue;
                subTargets.addAll(targetEntry.getValue());
            }
            if (subTargets.isEmpty()) continue;
            for (String sourceInstance : sourceInstances) {
                concurrentEvents.put(sourceInstance, subTargets);
            }
        }
        return concurrentEvents;
    }

    public abstract TreeMap<String, Set<String>> getConcurrentEvents(ACache var1, ACache var2, String var3);

    public abstract TreeMap<String, Set<String>> getPredecessorEvents(ACache var1, ACache var2, String var3);

    public abstract String getName();
}

