/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.string;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.measure.string.TrigramMeasure;

public class MongeElkanMapper
extends AMapper {
    private String split = " ";
    private TrigramMeasure trigram = new TrigramMeasure();

    public void setSplit(String split) {
        this.split = split;
    }

    public AMapping getMapping(Map<String, Set<String>> sourceMap, Map<String, Set<String>> targetMap, double threshold) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        Iterator<String> sit = sourceMap.keySet().iterator();
        HashMap similarityBook = new HashMap();
        while (sit.hasNext()) {
            Iterator<String> tit = targetMap.keySet().iterator();
            String sourceString = sit.next();
            HashMap<String, Double> resultB = new HashMap<String, Double>();
            while (tit.hasNext()) {
                String targetString = tit.next();
                double resultDouble = this.oneMongeElkan(sourceString.split(this.split), targetString.split(this.split), threshold);
                if (!(threshold <= resultDouble)) continue;
                resultB.put(targetString, resultDouble);
            }
            similarityBook.put(sourceString, resultB);
        }
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : similarityBook.keySet()) {
            for (String t : ((Map)similarityBook.get(s)).keySet()) {
                for (String sourceUri : sourceMap.get(s)) {
                    for (String targetUri : targetMap.get(t)) {
                        result.add(sourceUri, targetUri, (Double)((Map)similarityBook.get(s)).get(t));
                    }
                }
            }
        }
        return result;
    }

    private double oneMongeElkan(String[] sourceToken, String[] targetToken, double threshold) {
        double simB = 0.0;
        double result = 0.0;
        float maxNumber = sourceToken.length;
        float treshMin = (float)((double)maxNumber * threshold);
        for (String sourceString : sourceToken) {
            double maxSim = 0.0;
            for (String targetString : targetToken) {
                double sim = this.tokenSim(sourceString, targetString);
                if (maxSim < sim) {
                    maxSim = sim;
                }
                if (maxSim == 1.0) break;
            }
            if ((double)treshMin > (double)(maxNumber = (float)((double)maxNumber - (1.0 - maxSim))) + 1.0E-4) {
                result = 0.0;
                break;
            }
            simB += maxSim;
        }
        if (simB != 0.0) {
            result = simB / (double)sourceToken.length;
        }
        return result;
    }

    private double tokenSim(String tokenA, String tokenB) {
        double result = this.trigram.getSimilarity(tokenA, tokenB);
        return result;
    }

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Map<String, Set<String>> sourceMap = this.getValueToUriMap(source, properties.get(0));
        Map<String, Set<String>> targetMap = this.getValueToUriMap(target, properties.get(1));
        return this.getMapping(sourceMap, targetMap, threshold);
    }

    @Override
    public String getName() {
        return "monge-elkan";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }
}

