/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.string;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.measure.string.JaroMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaroMapper
extends AMapper {
    static Logger logger = LoggerFactory.getLogger(JaroMapper.class);

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Map<String, Set<String>> sourceMap = this.getValueToUriMap(source, properties.get(0));
        Map<String, Set<String>> targetMap = this.getValueToUriMap(target, properties.get(1));
        return this.runWithoutPrefixFilter(sourceMap, targetMap, threshold);
    }

    @Override
    public String getName() {
        return "jaro";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    private double getMaxComparisonLength(double length, double threshold, double maxLength) {
        double l = maxLength * length / ((3.0 * threshold - 1.0) * length - maxLength);
        if (l < 0.0) {
            return Double.MAX_VALUE;
        }
        return l;
    }

    public AMapping runLenghtOnly(Map<String, Set<String>> sourceMap, Map<String, Set<String>> targetMap, double threshold) {
        JaroMeasure j = new JaroMeasure();
        Set<String> source = sourceMap.keySet();
        Set<String> target = targetMap.keySet();
        Map<Integer, Set<String>> sourceLengthIndex = this.getLengthIndex(source);
        Map<Integer, Set<String>> targetLengthIndex = this.getLengthIndex(target);
        AMapping result = MappingFactory.createDefaultMapping();
        for (Integer sourceLength : sourceLengthIndex.keySet()) {
            for (Integer targetLength : targetLengthIndex.keySet()) {
                double maxSourceLength = this.getMaxComparisonLength(sourceLength.intValue(), threshold, Math.min(sourceLength, targetLength));
                double maxTargetLength = this.getMaxComparisonLength(targetLength.intValue(), threshold, Math.min(sourceLength, targetLength));
                if (!((double)sourceLength.intValue() <= maxTargetLength) || !((double)targetLength.intValue() <= maxSourceLength)) continue;
                for (String s : sourceLengthIndex.get(sourceLength)) {
                    for (String t : targetLengthIndex.get(targetLength)) {
                        double similarity = j.getSimilarity(s, t);
                        if (!(similarity >= threshold)) continue;
                        for (String sourceUri : sourceMap.get(s)) {
                            for (String targetUri : targetMap.get(t)) {
                                result.add(sourceUri, targetUri, similarity);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public AMapping run(Map<String, Set<String>> sourceMap, Map<String, Set<String>> targetMap, double threshold) {
        Set<String> source = sourceMap.keySet();
        Set<String> target = targetMap.keySet();
        Map<Integer, Set<String>> sourceLengthIndex = this.getLengthIndex(source);
        Map<Integer, Set<String>> targetLengthIndex = this.getLengthIndex(target);
        AMapping result = MappingFactory.createDefaultMapping();
        for (Integer sourceLength : sourceLengthIndex.keySet()) {
            for (Integer targetLength : targetLengthIndex.keySet()) {
                double maxTargetLength = this.getMaxComparisonLength(sourceLength.intValue(), threshold, Math.min(sourceLength, targetLength));
                double maxSourceLength = this.getMaxComparisonLength(targetLength.intValue(), threshold, Math.min(sourceLength, targetLength));
                if (!((double)sourceLength.intValue() <= maxSourceLength) || !((double)targetLength.intValue() <= maxTargetLength)) continue;
                double theta = (3.0 * threshold - 1.0) * (double)sourceLength.intValue() * (double)targetLength.intValue() / (double)(2 * (sourceLength + targetLength));
                int halfLength = Math.min(sourceLength, targetLength) / 2;
                int sourcePrefixLength = sourceLength - (int)theta;
                int targetPrefixLength = targetLength - (int)theta;
                for (String s : sourceLengthIndex.get(sourceLength)) {
                    Set<Character> sourcePrefix = this.getCharSet(s, sourcePrefixLength);
                    for (String t : targetLengthIndex.get(targetLength)) {
                        double similarity;
                        List<Character> targetMappingCharacters;
                        int transpositions;
                        List<Character> sourceMappingCharacters;
                        boolean passed = false;
                        Set<Character> targetPrefix = this.getCharSet(t, targetPrefixLength);
                        passed = sourcePrefix.isEmpty() || targetPrefix.isEmpty() ? true : this.contains(sourcePrefix, targetPrefix);
                        if (!passed || !((double)(sourceMappingCharacters = JaroMeasure.getCommonCharacters(s, t, halfLength)).size() >= theta) || (transpositions = JaroMeasure.getTranspositions(sourceMappingCharacters, targetMappingCharacters = JaroMeasure.getCommonCharacters(t, s, halfLength))) < 0 || !((similarity = (double)((float)sourceMappingCharacters.size() / (float)sourceLength.intValue() + (float)targetMappingCharacters.size() / (float)targetLength.intValue() + (float)(sourceMappingCharacters.size() - transpositions) / (float)sourceMappingCharacters.size()) / 3.0) >= threshold)) continue;
                        for (String sourceUri : sourceMap.get(s)) {
                            for (String targetUri : targetMap.get(t)) {
                                result.add(sourceUri, targetUri, similarity);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public AMapping runWithoutPrefixFilter(Map<String, Set<String>> sourceMap, Map<String, Set<String>> targetMap, double threshold) {
        Set<String> source = sourceMap.keySet();
        Set<String> target = targetMap.keySet();
        Map<Integer, Set<String>> sourceLengthIndex = this.getLengthIndex(source);
        Map<Integer, Set<String>> targetLengthIndex = this.getLengthIndex(target);
        AMapping result = MappingFactory.createDefaultMapping();
        for (Integer sourceLength : sourceLengthIndex.keySet()) {
            for (Integer targetLength : targetLengthIndex.keySet()) {
                double theta = (3.0 * threshold - 1.0) * (double)sourceLength.intValue() * (double)targetLength.intValue() / (double)(2 * (sourceLength + targetLength));
                int halfLength = Math.min(sourceLength, targetLength) / 2;
                double maxTargetLength = this.getMaxComparisonLength(sourceLength.intValue(), threshold, Math.min(sourceLength, targetLength));
                double maxSourceLength = this.getMaxComparisonLength(targetLength.intValue(), threshold, Math.min(sourceLength, targetLength));
                if (!((double)sourceLength.intValue() <= maxSourceLength) || !((double)targetLength.intValue() <= maxTargetLength)) continue;
                for (String s : sourceLengthIndex.get(sourceLength)) {
                    for (String t : targetLengthIndex.get(targetLength)) {
                        double similarity;
                        List<Character> targetMappingCharacters;
                        int transpositions;
                        List<Character> sourceMappingCharacters = JaroMeasure.getCommonCharacters(s, t, halfLength);
                        if (!((double)sourceMappingCharacters.size() >= theta) || (transpositions = JaroMeasure.getTranspositions(sourceMappingCharacters, targetMappingCharacters = JaroMeasure.getCommonCharacters(t, s, halfLength))) == -1 || !((similarity = (double)((float)sourceMappingCharacters.size() / (float)sourceLength.intValue() + (float)targetMappingCharacters.size() / (float)targetLength.intValue() + (float)(sourceMappingCharacters.size() - transpositions) / (float)sourceMappingCharacters.size()) / 3.0) >= threshold)) continue;
                        for (String sourceUri : sourceMap.get(s)) {
                            for (String targetUri : targetMap.get(t)) {
                                result.add(sourceUri, targetUri, similarity);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private boolean contains(Set<Character> source, Set<Character> target) {
        for (Character s : source) {
            if (!target.contains(s)) continue;
            return true;
        }
        return false;
    }

    private Map<Integer, Set<String>> getLengthIndex(Set<String> strings) {
        HashMap<Integer, Set<String>> result = new HashMap<Integer, Set<String>>();
        for (String s : strings) {
            Integer i = new Integer(s.length());
            if (!result.containsKey(i)) {
                result.put(i, new HashSet());
            }
            ((Set)result.get(i)).add(s);
        }
        return result;
    }

    private Set<Character> getCharSet(String s, int length) {
        HashSet<Character> result = new HashSet<Character>();
        char[] characters = s.toCharArray();
        for (int i = 0; i < characters.length && i < length; ++i) {
            result.add(Character.valueOf(characters[i]));
        }
        return result;
    }
}

