/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.GeoHR3;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.aksw.limes.core.measures.measure.pointsets.IPointsetsMeasure;

public class OrchidMapper
extends AMapper {
    IPointsetsMeasure m = null;

    public static List<Point> getPoints(String rawValue) {
        if (!rawValue.contains("(") || !rawValue.contains(")")) {
            return new ArrayList<Point>();
        }
        String s = rawValue.substring(rawValue.indexOf("(") + 1, rawValue.lastIndexOf(")"));
        s = s.replaceAll(Pattern.quote("("), "");
        s = s.replaceAll(Pattern.quote(")"), "");
        s = s.replaceAll(Pattern.quote("  "), "");
        s = s.replaceAll(Pattern.quote(" ,"), ",");
        s = s.replaceAll(Pattern.quote(", "), ",");
        String[] split = s.split(",");
        ArrayList<Point> result = new ArrayList<Point>();
        for (int i = 0; i < split.length; ++i) {
            String[] coords = split[i].split(" ");
            for (int j = 0; j < coords.length; j += 2) {
                ArrayList<Double> coordinates = new ArrayList<Double>();
                try {
                    coordinates.add(Double.parseDouble(coords[j].replaceAll(" ", "")));
                    coordinates.add(Double.parseDouble(coords[j + 1].replaceAll(" ", "")));
                    Point p = new Point("", coordinates);
                    result.add(p);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        return result;
    }

    public static Polygon getPolygon(String rawValue) {
        Polygon p = new Polygon("");
        List<Point> points = OrchidMapper.getPoints(rawValue);
        for (Point point : points) {
            p.add(point);
        }
        return p;
    }

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Set<Polygon> sourcePolygons = this.getPolygons(source, properties.get(0));
        Set<Polygon> targetPolygons = this.getPolygons(target, properties.get(1));
        float theta = 1.0f / (float)threshold - 1.0f;
        MeasureType type = null;
        type = MeasureFactory.getMeasureType(expression);
        GeoHR3 orchid = new GeoHR3(theta, GeoHR3.DEFAULT_GRANULARITY, type);
        return orchid.run(sourcePolygons, targetPolygons);
    }

    public Set<Polygon> getPolygons(ACache c, String property) {
        HashSet<Polygon> polygons = new HashSet<Polygon>();
        for (Instance instance : c.getAllInstances()) {
            Polygon p = new Polygon(instance.getUri());
            TreeSet<String> values = instance.getProperty(property);
            if (instance.getUri().contains("dbpedia")) {
                String value = values.first();
                value = value.replace(",", "");
                values = new TreeSet();
                values.add(value);
            }
            for (String v : values) {
                List<Point> points = OrchidMapper.getPoints(v);
                for (Point point : points) {
                    p.add(point);
                }
            }
            polygons.add(p);
        }
        return polygons;
    }

    @Override
    public String getName() {
        return "Orchid";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 16.27 + 5.1 * (double)sourceSize + 4.9 * (double)targetSize - 23.44 * threshold;
        }
        return 22.0 + 0.005 * (double)(sourceSize + targetSize) - 56.4 * threshold;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 2333.0 + 0.14 * (double)sourceSize + 0.14 * (double)targetSize - 3905.0 * threshold;
        }
        return 0.006 * (double)(sourceSize + targetSize) - 134.2 * threshold;
    }
}

