/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.serializer;

import org.aksw.limes.core.io.serializer.CSVSerializer;
import org.aksw.limes.core.io.serializer.ISerializer;
import org.aksw.limes.core.io.serializer.NtSerializer;
import org.aksw.limes.core.io.serializer.TTLSerializer;
import org.aksw.limes.core.io.serializer.TabSeparatedSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerFactory {
    private static Logger logger = LoggerFactory.getLogger((String)SerializerFactory.class.getName());

    public static ISerializer createSerializer(String name) {
        logger.info("Getting serializer with name " + name);
        if (name == null) {
            return new NtSerializer();
        }
        if (name.toLowerCase().trim().startsWith("tab")) {
            return new TabSeparatedSerializer();
        }
        if (name.toLowerCase().trim().startsWith("csv")) {
            return new CSVSerializer();
        }
        if (name.toLowerCase().trim().startsWith("ttl") || name.toLowerCase().trim().startsWith("turtle")) {
            return new TTLSerializer();
        }
        if (name.toLowerCase().trim().startsWith("nt") || name.toLowerCase().trim().startsWith("turtle")) {
            return new NtSerializer();
        }
        logger.info("Serializer with name " + name + " not found. Using .nt as default format.");
        return new NtSerializer();
    }

    public static ISerializer[] getAllSerializers() {
        return new ISerializer[]{SerializerFactory.createSerializer("nt"), SerializerFactory.createSerializer("csv"), SerializerFactory.createSerializer("tab"), SerializerFactory.createSerializer("ttl")};
    }
}

