/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.serializer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.serializer.ISerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtSerializer
implements ISerializer {
    private static Logger logger = LoggerFactory.getLogger((String)NtSerializer.class.getName());
    protected PrintWriter writer;
    protected Set<String> statements;
    protected Map<String, String> prefixMap;
    protected File folder = new File("");

    public NtSerializer() {
        this.prefixMap = new HashMap<String, String>();
        this.statements = new TreeSet<String>();
    }

    public NtSerializer(HashMap<String, String> prefixes) {
        this.statements = new TreeSet<String>();
        this.prefixMap = prefixes;
    }

    public static String expand(String s, String predicate) {
        if (predicate != null && s.indexOf(":") > 0) {
            String[] split = s.split(":");
            return predicate + split[1];
        }
        return s;
    }

    @Override
    public void addStatement(String subject, String predicate, String object, double similarity) {
        this.statements.add("<" + subject + "> <" + predicate + "> <" + object + "> .");
    }

    public void flush() {
        try {
            for (String s : this.statements) {
                this.writer.println(s);
            }
            this.statements = new TreeSet<String>();
        }
        catch (Exception e) {
            logger.warn("Error writing");
        }
    }

    @Override
    public void writeToFile(AMapping mapping, String predicate, String file) {
        this.open(file);
        String predicatePrefix = this.getPrefix(predicate);
        if (mapping.size() > 0) {
            for (String s : mapping.getMap().keySet()) {
                for (String t : mapping.getMap().get(s).keySet()) {
                    this.writer.println("<" + s + "> <" + NtSerializer.expand(predicate, predicatePrefix) + "> <" + t + "> .");
                }
            }
        }
        this.close();
    }

    @Override
    public void printStatement(String subject, String predicate, String object, double similarity) {
        String predicatePrefix = this.getPrefix(predicate);
        try {
            this.writer.println("<" + subject + "> <" + NtSerializer.expand(predicate, predicatePrefix) + "> <" + object + "> .");
        }
        catch (Exception e) {
            logger.warn("Error writing");
        }
    }

    public void printPrefixes(Map<String, String> prefixMap, String file) {
        this.open(file);
        for (Map.Entry<String, String> e : prefixMap.entrySet()) {
            String key = e.getKey();
            String url = e.getValue();
            if (!url.startsWith("<") && url.endsWith(">")) {
                url = "<" + e.getValue() + ">";
            }
            if (!key.endsWith(":")) {
                key = key + ":";
            }
            String out = "@prefix " + key + " " + url + " .";
            this.writer.println(out);
        }
        this.writer.flush();
    }

    @Override
    public boolean close() {
        try {
            if (this.statements.size() > 0) {
                for (String s : this.statements) {
                    this.writer.println(s);
                }
            }
            this.writer.close();
        }
        catch (Exception e) {
            logger.warn("Error closing PrintWriter");
            logger.warn(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean open(String file) {
        try {
            if (!file.contains("/") && !file.contains("\\")) {
                String filePath = this.folder.getAbsolutePath() + File.separatorChar + file;
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            } else {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
        }
        catch (Exception e) {
            logger.warn("Error creating PrintWriter");
            logger.warn(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "N3Serializer";
    }

    @Override
    public void setPrefixes(Map<String, String> prefixes) {
        this.prefixMap = prefixes;
    }

    private String getPrefix(String entry) {
        for (String prefix : this.prefixMap.keySet()) {
            if (!entry.startsWith(prefix + ":")) continue;
            return this.prefixMap.get(prefix);
        }
        return null;
    }

    @Override
    public String getFileExtension() {
        return "nt";
    }

    @Override
    public File getFile(String fileName) {
        return new File(this.folder.getAbsolutePath() + File.separatorChar + fileName);
    }

    @Override
    public void setFolderPath(File folder) {
        this.folder = folder;
    }
}

