/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.IQueryModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class VectorQueryModule
implements IQueryModule {
    KBInfo kb;
    String SEP = "\t";

    public VectorQueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    @Override
    public void fillCache(ACache c) {
        Logger logger = LoggerFactory.getLogger((String)"LIMES");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.kb.getEndpoint()));
            logger.info("Reading vectors from " + this.kb.getEndpoint());
            String s = reader.readLine();
            ArrayList<String> properties = new ArrayList<String>();
            properties.add(this.kb.getProperties().get(0));
            while (s != null) {
                if (s.contains(this.SEP)) {
                    String uri = s.substring(1, s.indexOf(this.SEP) - 1);
                    c.addTriple(uri, (String)properties.get(0), s.substring(s.indexOf(this.SEP)));
                }
                s = reader.readLine();
            }
            reader.close();
            logger.info("Retrieved " + c.size() + " statements");
        }
        catch (Exception e) {
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Exception:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

