/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.IQueryModule;
import org.aksw.limes.core.util.DataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class CsvQueryModule
implements IQueryModule {
    Logger logger = LoggerFactory.getLogger((String)CsvQueryModule.class.getName());
    KBInfo kb;
    private String SEP = ",";

    public CsvQueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    public void setSeparation(String s) {
        this.SEP = s;
    }

    @Override
    public void fillCache(ACache c) {
        try {
            BufferedReader reader;
            try {
                reader = new BufferedReader(new FileReader(new File(this.kb.getEndpoint())));
            }
            catch (Exception e) {
                reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(this.kb.getEndpoint())));
            }
            String s = reader.readLine();
            if (s != null) {
                ArrayList<String> properties = new ArrayList<String>();
                String[] split = s.split(this.SEP);
                properties.addAll(Arrays.asList(split));
                s = reader.readLine();
                while (s != null) {
                    split = DataCleaner.separate(s, this.SEP, properties.size());
                    String id = split[0];
                    for (String propertyLabel : this.kb.getProperties()) {
                        String value = split[properties.indexOf(propertyLabel)];
                        c.addTriple(id, propertyLabel, value);
                    }
                    s = reader.readLine();
                }
            } else {
                this.logger.warn("Input file " + this.kb.getEndpoint() + " was empty or faulty");
            }
            reader.close();
            this.logger.info("Retrieved " + c.size() + " statements");
        }
        catch (Exception e) {
            this.logger.error(MarkerFactory.getMarker((String)"FATAL"), "Exception:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void fillAllInCache(ACache c) {
        Logger logger = LoggerFactory.getLogger((String)"LIMES");
        String s = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.kb.getEndpoint()));
            s = reader.readLine();
            if (s != null) {
                ArrayList<String> properties = new ArrayList<String>();
                String[] split = s.split(this.SEP);
                properties.addAll(Arrays.asList(split));
                logger.info("Properties = " + properties);
                logger.info("KB Properties = " + this.kb.getProperties());
                this.kb.setProperties(properties);
                s = reader.readLine();
                while (s != null) {
                    split = s.split(this.SEP);
                    split = DataCleaner.separate(s, this.SEP, properties.size());
                    String id = split[0].substring(1, split[0].length() - 1);
                    for (String propertyLabel : this.kb.getProperties()) {
                        String value = split[properties.indexOf(propertyLabel)];
                        c.addTriple(id, propertyLabel, value.replaceAll(Pattern.quote("@en"), ""));
                    }
                    s = reader.readLine();
                }
            } else {
                logger.warn("Input file " + this.kb.getEndpoint() + " was empty or faulty");
            }
            reader.close();
            logger.info("Retrieved " + c.size() + " statements");
        }
        catch (Exception e) {
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Exception:" + e.getMessage());
            logger.warn(s);
            e.printStackTrace();
        }
    }
}

