/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.preprocessing.functions;

import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.preprocessing.APreprocessingFunction;
import org.aksw.limes.core.io.preprocessing.IPreprocessingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanNumber
extends APreprocessingFunction
implements IPreprocessingFunction {
    static Logger logger = LoggerFactory.getLogger(CleanNumber.class);
    public static final Pattern typedNumber = Pattern.compile("[0-9,.-]+(?=\\^)");
    public static final Pattern untypedNumber = Pattern.compile("-{0,1}[0-9]+.{0,1}[0-9]");

    @Override
    public Instance applyFunctionAfterCheck(Instance i, String property, String ... arguments) {
        TreeSet<String> oldValues = i.getProperty(property);
        TreeSet<String> newValues = new TreeSet<String>();
        for (String value : oldValues) {
            newValues.add(CleanNumber.removeTypeInformation(value));
        }
        i.replaceProperty(property, newValues);
        return i;
    }

    public static String removeTypeInformation(String number) {
        String newValue;
        if (untypedNumber.matcher(number).matches()) {
            return number;
        }
        Matcher m = typedNumber.matcher(number);
        if (m.find()) {
            newValue = m.group();
            try {
                Double.parseDouble(newValue);
            }
            catch (Exception e) {
                logger.error(newValue + " is not a parseable double\n Using 0 instead");
                return "0";
            }
        } else {
            logger.error(number + " is not a typed double\n Using 0 instead");
            return "0";
        }
        return newValue;
    }

    @Override
    public int minNumberOfArguments() {
        return 0;
    }

    @Override
    public int maxNumberOfArguments() {
        return 0;
    }
}

