/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.preprocessing;

import java.util.Map;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.preprocessing.APreprocessingFunction;
import org.aksw.limes.core.io.preprocessing.PreprocessingFunctionFactory;
import org.aksw.limes.core.io.preprocessing.PreprocessingFunctionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preprocessor {
    static Logger logger = LoggerFactory.getLogger((String)Preprocessor.class.getName());

    public static ACache applyFunctionsToCache(ACache cache, Map<String, Map<String, String>> functions) {
        return Preprocessor.applyFunctionsToCache(cache, functions, false);
    }

    public static ACache applyFunctionsToCache(ACache cache, Map<String, Map<String, String>> functions, boolean cloneCache) {
        ACache cacheClone = cloneCache ? cache.clone() : cache;
        functions.forEach((property, innerMap) -> innerMap.forEach((propertyDub, functionChain) -> {
            System.out.println((String)property);
            for (Instance inst : cacheClone.getAllInstances()) {
                logger.debug("Function chain = " + functionChain);
                Preprocessor.applyRenameIfNecessary(inst, property, propertyDub);
                if (functionChain == null || functionChain.equals("")) continue;
                String[] split = functionChain.split("->");
                for (int i = 0; i < split.length; ++i) {
                    String functionId = Preprocessor.getFunctionId(split[i]);
                    PreprocessingFunctionType type = PreprocessingFunctionFactory.getPreprocessingType(functionId);
                    APreprocessingFunction func = PreprocessingFunctionFactory.getPreprocessingFunction(type);
                    String[] arguments = func.retrieveArguments(split[i]);
                    if (arguments.length > 0) {
                        func.applyFunction(inst, (String)propertyDub, arguments);
                        continue;
                    }
                    func.applyFunction(inst, (String)propertyDub, new String[0]);
                }
            }
        }));
        return cacheClone;
    }

    public static void applyRenameIfNecessary(Instance inst, String property, String propertyDub) {
        if (!(property == null || property.equals("") || propertyDub == null || propertyDub.equals("") || property.equals(propertyDub))) {
            PreprocessingFunctionType type = PreprocessingFunctionFactory.getPreprocessingType("rename");
            APreprocessingFunction func = PreprocessingFunctionFactory.getPreprocessingFunction(type);
            func.applyFunction(inst, property, propertyDub);
        }
    }

    public static String getFunctionId(String argString) {
        return argString.split("\\(")[0];
    }
}

