/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.parser;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.aksw.limes.core.exceptions.InvalidMeasureException;
import org.aksw.limes.core.exceptions.UnsupportedOperator;
import org.aksw.limes.core.io.parser.IParser;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser
implements IParser {
    public static final Logger logger = LoggerFactory.getLogger((String)Parser.class.getName());
    public static final String MULT = "MULT";
    public static final String ADD = "ADD";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    protected double leftCoefficient = -1.0;
    protected double rightCoefficient = -1.0;
    protected String leftTerm;
    protected String rightTerm;
    protected String operator;
    protected String expression;
    private double threshold;
    private double threshold1;
    private double threshold2;

    public Parser(String input, double theta) {
        this.expression = input.replaceAll(" ", "");
        this.setThreshold(theta);
        this.getTerms();
    }

    @Override
    public boolean isAtomic() {
        String copy = this.expression.toLowerCase();
        try {
            if (MeasureFactory.getMeasureType(copy) != null) {
                return true;
            }
        }
        catch (InvalidMeasureException e) {
            if (copy.startsWith("max(") || copy.startsWith("min(") || copy.startsWith("and(") || copy.startsWith("or(") || copy.startsWith("add(") || copy.startsWith("xor(") || copy.startsWith("minus(") || copy.startsWith("mult(") || copy.startsWith("diff(")) {
                return false;
            }
            int index = copy.indexOf("(");
            String wrongOperator = copy.substring(0, index);
            if (StringUtils.countMatches((String)copy, (String)",") == 1) {
                throw new InvalidMeasureException(wrongOperator);
            }
            throw new UnsupportedOperator(wrongOperator);
        }
        return false;
    }

    public String getLeftTerm() {
        return this.leftTerm;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getRightTerm() {
        return this.rightTerm;
    }

    public double getLeftCoefficient() {
        if (this.leftCoefficient != -1.0) {
            return this.leftCoefficient;
        }
        this.leftCoefficient = 1.0;
        logger.debug("Parsing " + this.getRightTerm());
        if (this.leftTerm.contains("*")) {
            String[] split = this.leftTerm.split("\\*");
            try {
                this.leftCoefficient = Double.parseDouble(split[0]);
                this.leftTerm = Arrays.asList(split).stream().skip(1L).collect(Collectors.joining("*"));
            }
            catch (Exception e) {
                logger.warn("Error parsing " + this.leftTerm + " for coefficient <" + this.leftCoefficient + ">");
                this.leftCoefficient = 1.0;
            }
        }
        return this.leftCoefficient;
    }

    public double getRightCoefficient() {
        if (this.rightCoefficient != -1.0) {
            return this.rightCoefficient;
        }
        this.rightCoefficient = 1.0;
        logger.debug("Parsing " + this.getRightTerm());
        if (this.rightTerm.contains("*")) {
            String[] split = this.rightTerm.split("\\*");
            try {
                this.rightCoefficient = Double.parseDouble(split[0]);
                this.rightTerm = Arrays.asList(split).stream().skip(1L).collect(Collectors.joining("*"));
            }
            catch (Exception e) {
                this.rightCoefficient = 1.0;
                logger.warn("Error parsing " + this.rightTerm + " for coefficient");
            }
        }
        return this.rightCoefficient;
    }

    public void getTerms() {
        if (!this.isAtomic()) {
            int counter = 1;
            boolean found = false;
            this.operator = this.expression.substring(0, this.expression.indexOf("("));
            String noOpExpression = this.expression.substring(this.expression.indexOf("(") + 1, this.expression.lastIndexOf(")"));
            logger.debug("Expression stripped from operator = " + noOpExpression);
            for (int i = 0; i < noOpExpression.length(); ++i) {
                if (noOpExpression.charAt(i) == '(') {
                    ++counter;
                    found = true;
                    continue;
                }
                if (noOpExpression.charAt(i) == ')') {
                    --counter;
                    found = true;
                    continue;
                }
                if (counter != 1 || !found || noOpExpression.charAt(i) != ',') continue;
                this.leftTerm = noOpExpression.substring(0, i);
                this.rightTerm = noOpExpression.substring(i + 1);
            }
            this.leftCoefficient = -1.0;
            this.rightCoefficient = -1.0;
            this.getLeftCoefficient();
            this.getRightCoefficient();
            if (this.operator.equalsIgnoreCase(MIN) || this.operator.equalsIgnoreCase(MAX)) {
                this.setThreshold1(this.getThreshold());
                this.setThreshold2(this.getThreshold());
            } else if (this.operator.equalsIgnoreCase(ADD)) {
                this.operator = ADD;
                this.setThreshold1(Math.abs(this.getThreshold() - this.rightCoefficient) / this.leftCoefficient);
                this.setThreshold2(Math.abs(this.getThreshold() - this.leftCoefficient) / this.rightCoefficient);
            } else if (this.operator.equalsIgnoreCase(MULT)) {
                this.operator = MULT;
                this.setThreshold1(this.getThreshold() / (this.rightCoefficient * this.leftCoefficient));
                this.setThreshold2(this.getThreshold1());
            } else {
                int index = this.leftTerm.lastIndexOf("|");
                String set1 = this.leftTerm.substring(0, index);
                logger.debug("LeftTerm filtered = " + set1);
                String t = this.leftTerm.substring(index + 1, this.leftTerm.length());
                logger.debug("Term = " + set1 + ", filter = " + t);
                this.setThreshold1(Double.parseDouble(t));
                this.leftTerm = set1;
                index = this.rightTerm.lastIndexOf("|");
                String set2 = this.rightTerm.substring(0, index);
                logger.debug("RightTerm filtered = " + set2);
                t = this.rightTerm.substring(index + 1, this.rightTerm.length());
                logger.debug("Term = " + set2 + ", filter = " + t);
                this.setThreshold2(Double.parseDouble(t));
                this.rightTerm = set2;
            }
        } else {
            this.operator = this.expression.substring(0, this.expression.indexOf("("));
            String noOpExpression = this.expression.substring(this.expression.indexOf("(") + 1, this.expression.lastIndexOf(")"));
            String[] split = noOpExpression.split(",");
            this.leftTerm = split[0];
            this.rightTerm = split[1];
        }
    }

    public double getThreshold2() {
        return this.threshold2;
    }

    public void setThreshold2(double threshold2) {
        this.threshold2 = threshold2;
    }

    public double getThreshold1() {
        return this.threshold1;
    }

    public void setThreshold1(double threshold1) {
        this.threshold1 = threshold1;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }
}

