/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.mapping.reader;

import java.io.BufferedReader;
import java.io.FileReader;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.mapping.reader.AMappingReader;
import org.aksw.limes.core.util.DataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class CSVMappingReader
extends AMappingReader {
    private static final String COMMA = ",";
    static Logger logger = LoggerFactory.getLogger((String)CSVMappingReader.class.getName());
    protected String delimiter = ",";

    public CSVMappingReader(String file) {
        super(file);
    }

    public CSVMappingReader(String file, String delimiter) {
        this(file);
        this.delimiter = delimiter;
    }

    @Override
    public AMapping read() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String line = reader.readLine();
            reader.close();
            if (line != null) {
                String[] col = line.split(this.delimiter);
                if (col.length == 2) {
                    return this.readTwoColumnFile();
                }
                if (col.length == 3) {
                    try {
                        Double.parseDouble(col[2]);
                        return this.readThreeColumnFileWithSimilarity();
                    }
                    catch (NumberFormatException e) {
                        return this.readThreeColumnFile();
                    }
                }
                logger.error(MarkerFactory.getMarker((String)"FATAL"), "Format not supported");
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public AMapping readTwoColumnFile() {
        AMapping m = MappingFactory.createDefaultMapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String line = reader.readLine();
            while (line != null) {
                String[] split = DataCleaner.separate(line, this.delimiter, 2);
                if (!split[0].startsWith("id")) {
                    if (!split[0].startsWith("<")) {
                        m.add(split[0], split[1], 1.0);
                    } else {
                        m.add(split[0].substring(1, split[0].length() - 1), split[1].substring(1, split[1].length() - 1), 1.0);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public AMapping readThreeColumnFileWithSimilarity() {
        AMapping m = MappingFactory.createDefaultMapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String s = reader.readLine();
            while (s != null) {
                String[] split = s.split(this.delimiter);
                m.add(split[0].substring(1, split[0].length() - 1), split[1].substring(1, split[1].length() - 1), Double.parseDouble(split[2]));
                s = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public AMapping readThreeColumnFile() {
        AMapping m = MappingFactory.createDefaultMapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String s = reader.readLine();
            while (s != null) {
                String[] split = s.split(this.delimiter);
                m.add(this.removeQuotes(split[0]), this.removeQuotes(split[2]), 1.0);
                if (split[1].startsWith("\"<") && split[1].endsWith(">\"")) {
                    String tmp = this.removeQuotes(split[1]);
                    m.setPredicate(tmp.substring(1, tmp.length() - 1));
                } else {
                    m.setPredicate(this.removeQuotes(split[1]));
                }
                s = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    private String removeQuotes(String s) {
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String getSDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

