/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.config.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.rdf.LIMES;
import org.aksw.limes.core.io.config.writer.IConfigurationWriter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFConfigurationWriter
implements IConfigurationWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)RDFConfigurationWriter.class.getName());

    public static void writeModel(Model model, String format, String outputFile) throws IOException {
        logger.info("Saving dataset to " + outputFile + " ...");
        long starTime = System.currentTimeMillis();
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        model.write((OutputStream)fileOutputStream, format);
        fileOutputStream.close();
        logger.info("Saving file done in " + (System.currentTimeMillis() - starTime) + "ms.");
    }

    @Override
    public void write(Configuration configuration, String outputFile) throws IOException {
        String format;
        switch (format = outputFile.substring(outputFile.indexOf(".") + 1).trim().toLowerCase()) {
            case "n3": 
            case "nt": {
                this.write(configuration, outputFile, "N-TRIPLE");
                break;
            }
            case "ttl": {
                this.write(configuration, outputFile, "TTL");
                break;
            }
            case "rdf": {
                this.write(configuration, outputFile, null);
                break;
            }
            case "jsonld": {
                this.write(configuration, outputFile, "JSON-LD");
                break;
            }
            default: {
                logger.error("Serialization " + format + " is not yet implemented, exit with error!");
                throw new IOException("Serialization " + format + " is not yet implemented!");
            }
        }
    }

    @Override
    public void write(Configuration configuration, String outputFile, String format) throws IOException {
        Model m = ModelFactory.createDefaultModel();
        String uri = "http://limes.sf.net/ontology/" + System.currentTimeMillis();
        Resource s = ResourceFactory.createResource((String)uri);
        m.add(s, RDF.type, (RDFNode)LIMES.LimesSpecs);
        m.setNsPrefixes(configuration.getPrefixes());
        m.setNsPrefix("limes", "http://limes.sf.net/ontology/");
        m.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        m.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        Resource source = ResourceFactory.createResource((String)(uri + "_source"));
        m.add(s, LIMES.hasSource, (RDFNode)source);
        m.add(source, RDF.type, (RDFNode)LIMES.SourceDataset);
        m.add(source, RDFS.label, configuration.getSourceInfo().getId());
        m.add(source, LIMES.endPoint, (RDFNode)ResourceFactory.createResource((String)configuration.getSourceInfo().getEndpoint()));
        m.add(source, LIMES.type, String.valueOf(configuration.getSourceInfo().getType()));
        m.add(source, LIMES.variable, configuration.getSourceInfo().getVar());
        m.add(source, LIMES.pageSize, String.valueOf(configuration.getSourceInfo().getPageSize()));
        for (String string : configuration.getSourceInfo().getRestrictions()) {
            m.add(source, LIMES.restriction, string);
        }
        for (String string : configuration.getSourceInfo().getProperties()) {
            m.add(source, LIMES.property, string);
        }
        Resource target = ResourceFactory.createResource((String)(uri + "_target"));
        m.add(s, LIMES.hasTarget, (RDFNode)target);
        m.add(target, RDF.type, (RDFNode)LIMES.TargetDataset);
        m.add(target, RDFS.label, configuration.getTargetInfo().getId());
        m.add(target, LIMES.endPoint, (RDFNode)ResourceFactory.createResource((String)configuration.getTargetInfo().getEndpoint()));
        m.add(target, LIMES.type, String.valueOf(configuration.getTargetInfo().getType()));
        m.add(target, LIMES.variable, configuration.getTargetInfo().getVar() + "");
        m.add(target, LIMES.pageSize, String.valueOf(configuration.getTargetInfo().getPageSize()));
        for (String r : configuration.getTargetInfo().getRestrictions()) {
            m.add(target, LIMES.restriction, r);
        }
        for (String p : configuration.getTargetInfo().getProperties()) {
            m.add(target, LIMES.property, p);
        }
        Resource resource = ResourceFactory.createResource((String)(uri + "_metric"));
        m.add(s, LIMES.hasMetric, (RDFNode)resource);
        m.add(resource, RDF.type, (RDFNode)LIMES.Metric);
        m.add(resource, LIMES.expression, configuration.getMetricExpression());
        Resource acceptance = ResourceFactory.createResource((String)(uri + "_acceptance"));
        m.add(s, LIMES.hasAcceptance, (RDFNode)acceptance);
        m.add(acceptance, RDF.type, (RDFNode)LIMES.Acceptance);
        m.add(acceptance, LIMES.threshold, String.valueOf(configuration.getAcceptanceThreshold()));
        m.add(acceptance, LIMES.file, (RDFNode)ResourceFactory.createResource((String)configuration.getAcceptanceFile()));
        m.add(acceptance, LIMES.relation, (RDFNode)ResourceFactory.createResource((String)configuration.getAcceptanceRelation()));
        Resource review = ResourceFactory.createResource((String)(uri + "_review"));
        m.add(s, LIMES.hasReview, (RDFNode)review);
        m.add(review, RDF.type, (RDFNode)LIMES.Review);
        m.add(review, LIMES.threshold, String.valueOf(configuration.getVerificationThreshold()));
        m.add(review, LIMES.file, (RDFNode)ResourceFactory.createResource((String)configuration.getVerificationFile()));
        m.add(review, LIMES.relation, (RDFNode)ResourceFactory.createResource((String)configuration.getVerificationRelation()));
        m.add(s, LIMES.executionPlanner, configuration.getExecutionPlanner());
        m.add(s, LIMES.executionRewriter, configuration.getExecutionRewriter());
        m.add(s, LIMES.executionEngine, configuration.getExecutionEngine());
        m.add(s, LIMES.granularity, String.valueOf(configuration.getGranularity()));
        if (configuration.getOutputFormat() != null) {
            m.add(s, LIMES.outputFormat, configuration.getOutputFormat());
        }
        RDFConfigurationWriter.writeModel(m, format, outputFile);
    }
}

