/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.rewriter;

import org.aksw.limes.core.execution.rewriter.DefaultRewriter;
import org.aksw.limes.core.execution.rewriter.Rewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriterFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)RewriterFactory.class.getName());
    public static final String DEFAULT = "default";
    public static final String ALGEBRAIC = "algebraic";

    public static Rewriter getDefaultRewriter() {
        return RewriterFactory.getRewriter(RewriterType.DEFAULT);
    }

    public static RewriterType getRewriterType(String name) {
        if (name.equalsIgnoreCase(DEFAULT)) {
            return RewriterType.DEFAULT;
        }
        if (name.equalsIgnoreCase(ALGEBRAIC)) {
            return RewriterType.ALGEBRAIC;
        }
        logger.error("Sorry, " + name + " is not yet implemented. Returning the default rewriter type instead...");
        return RewriterType.DEFAULT;
    }

    public static Rewriter getRewriter(RewriterType type) {
        switch (type) {
            case DEFAULT: {
                return new DefaultRewriter();
            }
        }
        logger.warn(type.toString() + " is not yet implemented. Returning the default rewriter instead...");
        return RewriterFactory.getDefaultRewriter();
    }

    public static enum RewriterType {
        DEFAULT,
        ALGEBRAIC;

    }
}

