/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.plan;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.execution.planning.plan.IPlan;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plan
implements IPlan {
    static Logger logger = LoggerFactory.getLogger(Plan.class);
    protected double runtimeCost = 0.0;
    protected double mappingSize = 0.0;
    protected double selectivity = 1.0;
    protected List<Instruction> instructionList = new ArrayList<Instruction>();

    @Override
    public void addInstruction(Instruction instruction) {
        boolean added;
        if (instruction != null && !(added = this.instructionList.add(instruction))) {
            logger.info("ExecutionPlan.addInstructiun() failed");
        }
    }

    @Override
    public void removeInstruction(int index) {
        if (index >= this.getInstructionList().size() || index < 0) {
            logger.info("ExecutionPlan.removeInstructiun() failed");
        } else {
            this.instructionList.remove(index);
        }
    }

    @Override
    public void removeInstruction(Instruction instruction) {
        this.instructionList.remove(instruction);
    }

    @Override
    public List<Instruction> getInstructionList() {
        return this.instructionList;
    }

    public void setInstructionList(List<Instruction> instructionList) {
        this.instructionList = instructionList;
    }

    public boolean isEmpty() {
        return this.instructionList.isEmpty();
    }

    public boolean equals(Object other) {
        Plan o = (Plan)other;
        if (o == null) {
            return false;
        }
        return this.instructionList.equals(o.instructionList);
    }

    public int hashCode() {
        return this.instructionList.hashCode();
    }

    @Override
    public Plan clone() {
        Plan clone = new Plan();
        clone.setMappingSize(this.mappingSize);
        clone.setRuntimeCost(this.runtimeCost);
        clone.setSelectivity(this.selectivity);
        if (this.instructionList != null) {
            if (!this.instructionList.isEmpty()) {
                ArrayList<Instruction> cloneInstructionList = new ArrayList<Instruction>();
                for (Instruction i : this.instructionList) {
                    cloneInstructionList.add(i.clone());
                }
                clone.setInstructionList(cloneInstructionList);
            } else {
                clone.setInstructionList(new ArrayList<Instruction>());
            }
        } else {
            clone.setInstructionList(null);
        }
        return clone;
    }

    public int size() {
        return this.instructionList.size();
    }

    public double getRuntimeCost() {
        return this.runtimeCost;
    }

    public void setRuntimeCost(double runtimeCost) {
        this.runtimeCost = runtimeCost;
    }

    public double getMappingSize() {
        return this.mappingSize;
    }

    public void setMappingSize(double mappingSize) {
        this.mappingSize = mappingSize;
    }

    public double getSelectivity() {
        return this.selectivity;
    }

    public void setSelectivity(double selectivity) {
        this.selectivity = selectivity;
    }
}

