/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.execution.engine.ExecutionEngine;
import org.aksw.limes.core.execution.engine.filter.LinearFilter;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.plan.Plan;
import org.aksw.limes.core.execution.planning.planner.DynamicPlanner;
import org.aksw.limes.core.execution.planning.planner.IPlanner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.mapping.MemoryMapping;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.MapperFactory;
import org.aksw.limes.core.measures.mapper.MappingOperations;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExecutionEngine
extends ExecutionEngine {
    static Logger logger = LoggerFactory.getLogger(SimpleExecutionEngine.class);
    private HashMap<String, AMapping> dynamicResults = new HashMap();

    public SimpleExecutionEngine(ACache source, ACache target, String sourceVar, String targetVar) {
        super(source, target, sourceVar, targetVar);
    }

    public AMapping executeInstructions(Plan plan) {
        this.buffer = new ArrayList();
        if (plan.isEmpty()) {
            logger.info("Plan is empty. Done.");
            return MappingFactory.createDefaultMapping();
        }
        List<Instruction> instructions = plan.getInstructionList();
        AMapping m = MappingFactory.createDefaultMapping();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction inst = instructions.get(i);
            int index = inst.getResultIndex();
            if (inst.getCommand().equals((Object)Instruction.Command.RUN)) {
                m = this.executeRun(inst);
            } else if (inst.getCommand().equals((Object)Instruction.Command.FILTER)) {
                m = this.executeFilter(inst, (AMapping)this.buffer.get(inst.getSourceIndex()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.REVERSEFILTER)) {
                m = this.executeReverseFilter(inst, (AMapping)this.buffer.get(inst.getSourceIndex()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.INTERSECTION)) {
                m = this.executeIntersection((AMapping)this.buffer.get(inst.getSourceIndex()), (AMapping)this.buffer.get(inst.getTargetIndex()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.UNION)) {
                m = this.executeUnion((AMapping)this.buffer.get(inst.getSourceIndex()), (AMapping)this.buffer.get(inst.getTargetIndex()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.DIFF)) {
                m = this.executeDifference((AMapping)this.buffer.get(inst.getSourceIndex()), (AMapping)this.buffer.get(inst.getTargetIndex()));
            } else if (inst.getCommand().equals((Object)Instruction.Command.XOR)) {
                LinearFilter f = new LinearFilter();
                AMapping m1 = this.executeUnion((AMapping)this.buffer.get(inst.getSourceIndex()), (AMapping)this.buffer.get(inst.getTargetIndex()));
                m1 = f.filter(m1, Double.parseDouble(inst.getThreshold()));
                AMapping m2 = this.executeIntersection((AMapping)this.buffer.get(inst.getSourceIndex()), (AMapping)this.buffer.get(inst.getTargetIndex()));
                m2 = f.filter(m2, Double.parseDouble(inst.getThreshold()));
                m = this.executeDifference(m1, m2);
            } else if (inst.getCommand().equals((Object)Instruction.Command.RETURN)) {
                if (this.buffer.isEmpty()) {
                    return m;
                }
                if (index < 0) {
                    return (AMapping)this.buffer.get(this.buffer.size() - 1);
                }
                return (AMapping)this.buffer.get(index);
            }
            if (index < 0) {
                this.buffer.add((MemoryMapping)m);
                continue;
            }
            if (index < this.buffer.size()) {
                this.buffer.add((MemoryMapping)m);
                continue;
            }
            while (index + 1 > this.buffer.size()) {
                this.buffer.add(MappingFactory.createDefaultMapping());
            }
            this.buffer.set(index, (MemoryMapping)m);
        }
        if (this.buffer.isEmpty()) {
            return MappingFactory.createDefaultMapping();
        }
        return (AMapping)this.buffer.get(this.buffer.size() - 1);
    }

    public AMapping executeRun(Instruction inst) {
        double threshold = Double.parseDouble(inst.getThreshold());
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        MeasureType type = MeasureFactory.getMeasureType(inst.getMeasureExpression());
        AMapper mapper = MapperFactory.createMapper(type);
        return mapper.getMapping(this.source, this.target, this.sourceVariable, this.targetVariable, inst.getMeasureExpression(), threshold);
    }

    private AMapping executeReverseFilter(Instruction inst, AMapping input) {
        LinearFilter filter = new LinearFilter();
        return filter.reversefilter(input, inst.getMeasureExpression(), Double.parseDouble(inst.getThreshold()), Double.parseDouble(inst.getMainThreshold()), this.source, this.target, this.sourceVariable, this.targetVariable);
    }

    public AMapping executeFilter(Instruction inst, AMapping input) {
        LinearFilter filter = new LinearFilter();
        AMapping m = MappingFactory.createDefaultMapping();
        m = inst.getMeasureExpression() == null ? filter.filter(input, Double.parseDouble(inst.getThreshold())) : (inst.getMainThreshold() != null ? filter.filter(input, inst.getMeasureExpression(), Double.parseDouble(inst.getThreshold()), Double.parseDouble(inst.getMainThreshold()), this.source, this.target, this.sourceVariable, this.targetVariable) : filter.filter(input, inst.getMeasureExpression(), Double.parseDouble(inst.getThreshold()), this.source, this.target, this.sourceVariable, this.targetVariable));
        return m;
    }

    public AMapping executeDifference(AMapping m1, AMapping m2) {
        return MappingOperations.difference(m1, m2);
    }

    public AMapping executeIntersection(AMapping m1, AMapping m2) {
        return MappingOperations.intersection(m1, m2);
    }

    public AMapping executeUnion(AMapping m1, AMapping m2) {
        return MappingOperations.union(m1, m2);
    }

    public AMapping executeStatic(NestedPlan plan) {
        AMapping m = MappingFactory.createDefaultMapping();
        if (!plan.isEmpty()) {
            if (plan.isAtomic()) {
                m = this.executeInstructions(plan);
            } else {
                AMapping result = m = this.executeStatic(plan.getSubPlans().get(0));
                for (int i = 1; i < plan.getSubPlans().size(); ++i) {
                    AMapping m2 = this.executeStatic(plan.getSubPlans().get(i));
                    if (plan.getOperator().equals((Object)Instruction.Command.INTERSECTION)) {
                        result = this.executeIntersection(m, m2);
                    } else if (plan.getOperator().equals((Object)Instruction.Command.UNION)) {
                        result = this.executeUnion(m, m2);
                    } else if (plan.getOperator().equals((Object)Instruction.Command.DIFF)) {
                        result = this.executeDifference(m, m2);
                    } else if (plan.getOperator().equals((Object)Instruction.Command.XOR)) {
                        LinearFilter f = new LinearFilter();
                        AMapping mleft = this.executeUnion(m, m2);
                        mleft = f.filter(mleft, Double.parseDouble(plan.getThreshold()));
                        AMapping mright = this.executeIntersection(m, m2);
                        mright = f.filter(mright, Double.parseDouble(plan.getThreshold()));
                        result = this.executeDifference(mleft, mright);
                    }
                    m = result;
                }
                if (plan.getFilteringInstruction() != null) {
                    m = this.executeFilter(plan.getFilteringInstruction(), m);
                }
            }
        }
        return m;
    }

    public AMapping executeDynamic(LinkSpecification spec, DynamicPlanner planner) {
        long begin = System.currentTimeMillis();
        long end = 0L;
        AMapping m = MappingFactory.createDefaultMapping();
        NestedPlan plan = new NestedPlan();
        if (!planner.isExecuted(spec)) {
            String dependent = planner.getDependency(spec);
            if (dependent != null) {
                AMapping dependentM = this.dynamicResults.get(dependent);
                if (spec.getThreshold() > 0.0) {
                    Instruction tempFilteringInstruction = new Instruction(Instruction.Command.FILTER, null, spec.getThreshold() + "", -1, -1, 0);
                    m = this.executeFilter(tempFilteringInstruction, dependentM);
                }
            } else if (!spec.isEmpty()) {
                if (spec.isAtomic()) {
                    plan = planner.getPlan(spec);
                    if (plan.isEmpty()) {
                        plan = planner.plan(spec);
                    }
                    m = this.executeInstructions(plan);
                } else {
                    plan = planner.plan(spec);
                    LinkSpecification firstSpec = planner.getLinkSpec(plan.getSubPlans().get(0));
                    AMapping result = m = this.executeDynamic(firstSpec, planner);
                    if (spec.getOperator().equals((Object)LogicOperator.AND)) {
                        plan = planner.plan(spec);
                        if (plan.getOperator() == null) {
                            if (plan.getFilteringInstruction().getCommand().equals((Object)Instruction.Command.FILTER)) {
                                result = this.executeFilter(plan.getFilteringInstruction(), m);
                            }
                        } else {
                            LinkSpecification secondSpec = planner.getLinkSpec(plan.getSubPlans().get(1));
                            AMapping m2 = this.executeDynamic(secondSpec, planner);
                            result = this.executeIntersection(m, m2);
                        }
                    } else if (spec.getOperator().equals((Object)LogicOperator.OR)) {
                        LinkSpecification secondSpec = planner.getLinkSpec(plan.getSubPlans().get(1));
                        if (secondSpec == null) {
                            plan = planner.plan(spec);
                            secondSpec = planner.getLinkSpec(plan.getSubPlans().get(1));
                        }
                        AMapping m2 = this.executeDynamic(secondSpec, planner);
                        result = this.executeUnion(m, m2);
                    } else if (spec.getOperator().equals((Object)LogicOperator.MINUS)) {
                        plan = planner.plan(spec);
                        if (plan.getOperator() == null) {
                            if (plan.getFilteringInstruction().getCommand().equals((Object)Instruction.Command.REVERSEFILTER)) {
                                result = this.executeReverseFilter(plan.getFilteringInstruction(), m);
                            }
                        } else {
                            LinkSpecification secondSpec = planner.getLinkSpec(plan.getSubPlans().get(1));
                            AMapping m2 = this.executeDynamic(secondSpec, planner);
                            result = this.executeDifference(m, m2);
                        }
                    } else if (spec.getOperator().equals((Object)LogicOperator.XOR)) {
                        LinkSpecification secondSpec = planner.getLinkSpec(plan.getSubPlans().get(1));
                        if (secondSpec == null) {
                            plan = planner.plan(spec);
                            secondSpec = planner.getLinkSpec(plan.getSubPlans().get(1));
                        }
                        AMapping m2 = this.executeDynamic(secondSpec, planner);
                        LinearFilter f = new LinearFilter();
                        AMapping mleft = this.executeUnion(m, m2);
                        mleft = f.filter(mleft, Double.parseDouble(plan.getThreshold()));
                        AMapping mright = this.executeIntersection(m, m2);
                        mright = f.filter(mright, Double.parseDouble(plan.getThreshold()));
                        result = this.executeDifference(mleft, mright);
                    }
                    m = result;
                    if (plan.getOperator() != null && plan.getFilteringInstruction() != null) {
                        m = this.executeFilter(plan.getFilteringInstruction(), m);
                    }
                }
            }
            this.dynamicResults.put(spec.toString(), MappingFactory.createDefaultMapping());
            this.dynamicResults.put(spec.toString(), m);
            end = System.currentTimeMillis();
            double msize = m.getNumberofMappings();
            double selectivity = msize / (double)(this.source.size() * this.target.size());
            planner.updatePlan(spec, end - begin, selectivity, msize);
        } else if (this.dynamicResults.containsKey(spec.toString())) {
            m = this.dynamicResults.get(spec.toString());
        } else {
            logger.info("Error in spec: " + spec + ". Result not stored.");
            throw new RuntimeException();
        }
        return m;
    }

    @Override
    public AMapping execute(LinkSpecification spec, IPlanner planner) {
        AMapping m = MappingFactory.createDefaultMapping();
        spec = planner.normalize(spec);
        if (!planner.isStatic()) {
            m = this.executeDynamic(spec, (DynamicPlanner)planner);
        } else {
            NestedPlan plan = planner.plan(spec);
            m = this.executeStatic(plan);
        }
        return m;
    }
}

