/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRecall;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoRefRecall
extends PseudoRecall {
    static Logger logger = LoggerFactory.getLogger(PseudoRefRecall.class);

    @Override
    public double calculate(AMapping predictions, GoldStandard goldStandard) {
        AMapping res = predictions;
        if (this.useOneToOneMapping) {
            res = predictions.getBestOneToOneMappings(predictions);
        }
        double size = 0.0;
        for (String s : res.getMap().keySet()) {
            size += (double)res.getMap().get(s).size();
        }
        return size / (double)Math.min(goldStandard.sourceUris.size(), goldStandard.targetUris.size());
    }
}

