/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.APseudoPRF;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoPrecision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRecall;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoFMeasure
extends APseudoPRF {
    static Logger logger = LoggerFactory.getLogger(PseudoFMeasure.class);

    public PseudoFMeasure() {
    }

    public PseudoFMeasure(boolean symmetricPrecision) {
        this();
        this.setSymmetricPrecision(symmetricPrecision);
    }

    @Override
    public double calculate(AMapping predictions, GoldStandard goldStandard) {
        return this.getPseudoFMeasure(predictions, goldStandard, 1.0);
    }

    public double getPseudoFMeasure(AMapping predictions, GoldStandard goldStandard, double beta) {
        double p = this.precision(predictions, goldStandard);
        double r = this.recall(predictions, goldStandard);
        if (p == 0.0 && r == 0.0) {
            return 0.0;
        }
        double f = (1.0 + beta * beta) * p * r / (beta * beta * p + r);
        return f;
    }

    public double recall(AMapping predictions, GoldStandard goldStandard) {
        return new PseudoRecall().calculate(predictions, goldStandard);
    }

    public double precision(AMapping predictions, GoldStandard goldStandard) {
        return new PseudoPrecision().calculate(predictions, goldStandard);
    }
}

