/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import java.util.HashSet;
import java.util.List;
import org.aksw.limes.core.io.mapping.AMapping;

@Deprecated
public class PseudoFM {
    public boolean symmetricPrecision = true;
    boolean use1To1Mapping = false;

    public PseudoFM() {
    }

    public PseudoFM(boolean symmetricPrecision) {
        this();
        this.symmetricPrecision = symmetricPrecision;
    }

    public boolean isUse1To1Mapping() {
        return this.use1To1Mapping;
    }

    public void setUse1To1Mapping(boolean use1To1Mapping) {
        this.use1To1Mapping = use1To1Mapping;
    }

    public double getPseudoFMeasure(List<String> sourceUris, List<String> targetUris, AMapping result) {
        return this.getPseudoFMeasure(sourceUris, targetUris, result, 1.0);
    }

    public double getPseudoFMeasure(List<String> sourceUris, List<String> targetUris, AMapping result, double beta) {
        double p = this.getPseudoPrecision(sourceUris, targetUris, result);
        double r = this.getPseudoRecall(sourceUris, targetUris, result);
        if (p == 0.0 && r == 0.0) {
            return 0.0;
        }
        double f = (1.0 + beta * beta) * p * r / (beta * beta * p + r);
        return f;
    }

    public double getPseudoPrecision(List<String> sourceUris, List<String> targetUris, AMapping result) {
        AMapping res = result;
        AMapping rev = res.reverseSourceTarget();
        if (this.use1To1Mapping) {
            res = result.getBestOneToNMapping();
            rev = res.reverseSourceTarget().getBestOneToNMapping();
        }
        double p = res.getMap().keySet().size();
        if (this.symmetricPrecision) {
            p = res.getMap().keySet().size() + rev.getMap().keySet().size();
        }
        double q = 0.0;
        for (String s : result.getMap().keySet()) {
            if (this.symmetricPrecision) {
                q += (double)(2 * result.getMap().get(s).size());
                continue;
            }
            q += (double)result.getMap().get(s).size();
        }
        if (p == 0.0 || q == 0.0) {
            return 0.0;
        }
        return p / q;
    }

    public double getPseudoRecall(List<String> sourceUris, List<String> targetUris, AMapping result) {
        AMapping res = result;
        if (this.use1To1Mapping) {
            res = result.getBestOneToNMapping();
        }
        double q = res.getMap().keySet().size();
        HashSet<String> values = new HashSet<String>();
        for (String s : res.getMap().keySet()) {
            for (String t : res.getMap().get(s).keySet()) {
                values.add(t);
            }
        }
        double reference = sourceUris.size() + targetUris.size();
        return (q + (double)values.size()) / reference;
    }
}

