/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluationDataLoader;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAEIMappingParser
extends DefaultHandler {
    static Logger logger = LoggerFactory.getLogger(OAEIMappingParser.class);
    AMapping m = MappingFactory.createMapping(MappingFactory.MappingType.HYBIRD_MAPPING);
    String xmlFile = "";
    String tmpValue;
    String uri1 = "";
    String uri2 = "";
    double idValue = 0.0;

    public OAEIMappingParser(String file) {
        this.xmlFile = file;
    }

    public AMapping parseDocument() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.xmlFile, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            System.err.println("ParserConfig error: ");
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.err.println("SAXException : xml not well formed");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IO error");
            e.printStackTrace();
        }
        return this.m;
    }

    @Override
    public void startElement(String s, String s1, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equalsIgnoreCase("cell")) {
            this.uri1 = "";
            this.uri2 = "";
            this.idValue = Double.NaN;
        }
        if (elementName.equalsIgnoreCase("entity1")) {
            this.uri1 = attributes.getValue("rdf:resource");
        }
        if (elementName.equalsIgnoreCase("entity2")) {
            this.uri2 = attributes.getValue("rdf:resource");
        }
        if (elementName.equalsIgnoreCase("measure")) {
            this.idValue = Double.NaN;
        }
    }

    @Override
    public void endElement(String s, String s1, String element) throws SAXException {
        if (element.equalsIgnoreCase("cell")) {
            this.m.add(this.uri1, this.uri2, this.idValue);
        }
        if (element.equalsIgnoreCase("measure")) {
            this.idValue = Double.parseDouble(this.tmpValue);
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        this.tmpValue = new String(ac, i, j);
    }
}

