/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluationDataLoader;

import java.io.File;
import java.util.Map;
import org.aksw.limes.core.evaluation.evaluationDataLoader.DataSetChooser;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationData {
    static Logger logger = LoggerFactory.getLogger(EvaluationData.class);
    private String name;
    private String baseFolder = "reources/";
    private String datasetFolder;
    private String configFileName;
    private String sourceFileName;
    private String targetFileName;
    private String goldStandardFile;
    private String evauationResultFolder = "resources/results/";
    private String evaluationResultFileName;
    private AConfigurationReader configReader;
    private PropertyMapping propertyMapping;
    private ACache sourceCache;
    private ACache targetCache;
    private String sourceClass;
    private String targetClass;
    private AMapping referenceMapping;
    private int maxRuns = 5;

    public static EvaluationData buildFromHashMap(Map<DataSetChooser.MapKey, Object> map) {
        EvaluationData data = new EvaluationData();
        data.baseFolder = (String)map.get((Object)DataSetChooser.MapKey.BASE_FOLDER);
        data.configFileName = (String)map.get((Object)DataSetChooser.MapKey.CONFIG_FILE);
        data.configReader = (AConfigurationReader)map.get((Object)DataSetChooser.MapKey.CONFIG_READER);
        data.datasetFolder = (String)map.get((Object)DataSetChooser.MapKey.DATASET_FOLDER);
        data.evaluationResultFileName = (String)map.get((Object)DataSetChooser.MapKey.EVALUATION_FILENAME);
        data.evauationResultFolder = (String)map.get((Object)DataSetChooser.MapKey.EVALUATION_RESULTS_FOLDER);
        data.goldStandardFile = (String)map.get((Object)DataSetChooser.MapKey.REFERENCE_FILE);
        data.name = (String)map.get((Object)DataSetChooser.MapKey.NAME);
        data.propertyMapping = (PropertyMapping)map.get((Object)DataSetChooser.MapKey.PROPERTY_MAPPING);
        data.referenceMapping = (AMapping)map.get((Object)DataSetChooser.MapKey.REFERENCE_MAPPING);
        data.sourceCache = (ACache)map.get((Object)DataSetChooser.MapKey.SOURCE_CACHE);
        data.sourceFileName = (String)map.get((Object)DataSetChooser.MapKey.SOURCE_FILE);
        data.targetCache = (ACache)map.get((Object)DataSetChooser.MapKey.TARGET_CACHE);
        data.targetFileName = (String)map.get((Object)DataSetChooser.MapKey.TARGET_FILE);
        data.sourceClass = (String)map.get((Object)DataSetChooser.MapKey.SOURCE_CLASS);
        data.targetClass = (String)map.get((Object)DataSetChooser.MapKey.TARGET_CLASS);
        return data;
    }

    public File getConfigFile() {
        return new File(this.baseFolder + this.configFileName);
    }

    public File getSourceFile() {
        return new File(this.datasetFolder + this.sourceFileName);
    }

    public File getTargetFile() {
        return new File(this.datasetFolder + this.targetFileName);
    }

    public File getReferenceDataFile() {
        return new File(this.datasetFolder + this.goldStandardFile);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseFolder() {
        return this.baseFolder;
    }

    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    public String getDatasetFolder() {
        return this.datasetFolder;
    }

    public void setDatasetFolder(String datasetFolder) {
        this.datasetFolder = datasetFolder;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public String getGoldStandardFile() {
        return this.goldStandardFile;
    }

    public void setGoldStandardFile(String goldStandardFile) {
        this.goldStandardFile = goldStandardFile;
    }

    public String getEvauationResultFolder() {
        return this.evauationResultFolder;
    }

    public void setEvauationResultFolder(String evauationResultFolder) {
        this.evauationResultFolder = evauationResultFolder;
    }

    public String getEvaluationResultFileName() {
        return this.evaluationResultFileName;
    }

    public void setEvaluationResultFileName(String evaluationResultFileName) {
        this.evaluationResultFileName = evaluationResultFileName;
    }

    public AConfigurationReader getConfigReader() {
        return this.configReader;
    }

    public void setConfigReader(AConfigurationReader configReader) {
        this.configReader = configReader;
    }

    public PropertyMapping getPropertyMapping() {
        return this.propertyMapping;
    }

    public void setPropertyMapping(PropertyMapping propertyMapping) {
        this.propertyMapping = propertyMapping;
    }

    public ACache getTargetCache() {
        return this.targetCache;
    }

    public void setTargetCache(ACache targetCache) {
        this.targetCache = targetCache;
    }

    public ACache getSourceCache() {
        return this.sourceCache;
    }

    public void setSourceCache(ACache sourceCache) {
        this.sourceCache = sourceCache;
    }

    public AMapping getReferenceMapping() {
        return this.referenceMapping;
    }

    public void setReferenceMapping(AMapping referenceMapping) {
        this.referenceMapping = referenceMapping;
    }

    public Object getValue(DataSetChooser.MapKey key) {
        switch (key) {
            case BASE_FOLDER: {
                return this.getBaseFolder();
            }
            case CONFIG_FILE: {
                return this.getConfigFileName();
            }
            case CONFIG_READER: {
                return this.getConfigReader();
            }
            case DATASET_FOLDER: {
                return this.getDatasetFolder();
            }
            case EVALUATION_FILENAME: {
                return this.getEvaluationResultFileName();
            }
            case EVALUATION_RESULTS_FOLDER: {
                return this.getEvauationResultFolder();
            }
            case MAX_RUNS: {
                return this.getMaxRuns();
            }
            case NAME: {
                return this.getName();
            }
            case PROPERTY_MAPPING: {
                return this.getPropertyMapping();
            }
            case REFERENCE_FILE: {
                return this.getGoldStandardFile();
            }
            case REFERENCE_MAPPING: {
                return this.getReferenceMapping();
            }
            case SOURCE_CACHE: {
                return this.getSourceCache();
            }
            case SOURCE_FILE: {
                return this.getSourceFileName();
            }
            case TARGET_CACHE: {
                return this.getTargetCache();
            }
            case TARGET_FILE: {
                return this.getTargetFileName();
            }
        }
        return null;
    }

    public int getMaxRuns() {
        return this.maxRuns;
    }

    public void setMaxRuns(int maxRuns) {
        this.maxRuns = maxRuns;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(String sourceClass) {
        this.sourceClass = sourceClass;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }
}

