/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.datastrutures;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.evaluation.quantitativeMeasures.RunRecord;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.apache.commons.math3.util.Pair;

public class EvaluationRun {
    private final int stringSize = 200;
    private String algorithmName = "";
    private String implementationType = "";
    private String datasetName = "";
    public Map<EvaluatorType, Double> qualititativeScores = new HashMap<EvaluatorType, Double>();
    public Map<EvaluatorType, Pair<Double, Double>> qualititativeScoresWithVariance = new HashMap<EvaluatorType, Pair<Double, Double>>();
    private int runInExperiment = 0;
    RunRecord quanititativeRecord = new RunRecord();
    private LinkSpecification learnedLS;

    public EvaluationRun() {
    }

    public EvaluationRun(String algorithmName, String datasetName, Map<EvaluatorType, Double> evaluatorsScores) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
    }

    public EvaluationRun(String algorithmName, String implementation, String datasetName, Map<EvaluatorType, Double> evaluatorsScores) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        this.implementationType = implementation;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
    }

    public EvaluationRun(String algorithmName, String implementation, String datasetName, Map<EvaluatorType, Double> evaluatorsScores, int run) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        this.implementationType = implementation;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
        this.runInExperiment = run;
    }

    public EvaluationRun(String algorithmName, String implementation, String datasetName, Map<EvaluatorType, Double> evaluatorsScores, LinkSpecification learnedLS) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        this.implementationType = implementation;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
        this.learnedLS = learnedLS;
    }

    public EvaluationRun(String algorithmName, String implementation, String datasetName, Map<EvaluatorType, Double> evaluatorsScores, int run, LinkSpecification learnedLS) {
        this(algorithmName, implementation, datasetName, evaluatorsScores, learnedLS);
        this.runInExperiment = run;
    }

    public EvaluationRun(String algorithmName, String datasetName, Map<EvaluatorType, Double> evaluatorsScores, RunRecord quantitativeRecord) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
        this.quanititativeRecord = quantitativeRecord;
    }

    public Set<EvaluatorType> getQualititativeMeasures() {
        return this.qualititativeScores.keySet();
    }

    public void display() {
        System.out.println("==================================================================================================================");
        System.out.println("ALGORITHM_NAME\tIMPLEMENTATION\tDATASET");
        System.out.println(this.getAlgorithmName() + "\t" + this.getImplementationType() + "\t" + this.getDatasetName());
        System.out.println("------------------------------------------------------------------------------------------------------------------");
        for (EvaluatorType evaluator : this.qualititativeScores.keySet()) {
            System.out.println((Object)((Object)evaluator) + "\t" + this.qualititativeScores.get((Object)evaluator));
        }
        if (this.learnedLS != null) {
            System.out.println("------------------------------------------------------------------------------------------------------------------");
            System.out.println(this.learnedLS.toStringPretty());
        }
        System.out.println("==================================================================================================================");
    }

    public String toString() {
        String erString = this.Serialize(":");
        return erString + "\n";
    }

    public String Serialize(String separator) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getAlgorithmName());
        sb.append(separator);
        sb.append(this.getImplementationType());
        sb.append(separator);
        sb.append(this.getDatasetName());
        sb.append(separator);
        for (EvaluatorType evaluator : this.qualititativeScores.keySet()) {
            sb.append(this.qualititativeScores.get((Object)evaluator).toString());
            sb.append(separator);
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public int getRunInExperiment() {
        return this.runInExperiment;
    }

    public void setRunInExperiment(int runInExperiment) {
        this.runInExperiment = runInExperiment;
    }

    public RunRecord getQuanititativeRecord() {
        return this.quanititativeRecord;
    }

    public void setQuanititativeRecord(RunRecord quanititativeRecord) {
        this.quanititativeRecord = quanititativeRecord;
    }

    public EvaluationRun clone() {
        EvaluationRun clone = new EvaluationRun();
        clone.algorithmName = this.algorithmName;
        clone.implementationType = this.implementationType;
        clone.datasetName = this.datasetName;
        HashMap<EvaluatorType, Double> cloneQualiScores = new HashMap<EvaluatorType, Double>();
        this.qualititativeScores.forEach((key, value) -> cloneQualiScores.put((EvaluatorType)((Object)key), (Double)value));
        clone.qualititativeScores = cloneQualiScores;
        HashMap<EvaluatorType, Pair<Double, Double>> cloneQualiScoresWithVariance = new HashMap<EvaluatorType, Pair<Double, Double>>();
        this.qualititativeScoresWithVariance.forEach((key, value) -> cloneQualiScoresWithVariance.put((EvaluatorType)((Object)key), (Pair<Double, Double>)new Pair(value.getFirst(), value.getSecond())));
        clone.qualititativeScoresWithVariance = cloneQualiScoresWithVariance;
        clone.runInExperiment = this.runInExperiment;
        if (this.quanititativeRecord != null) {
            clone.quanititativeRecord = this.quanititativeRecord.clone();
        }
        if (this.learnedLS != null) {
            clone.learnedLS = this.learnedLS.clone();
        }
        return clone;
    }
}

