/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import org.aksw.limes.core.controller.Controller;
import org.aksw.limes.core.controller.ResultMappings;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.serializer.ISerializer;
import org.aksw.limes.core.io.serializer.SerializerFactory;
import org.apache.commons.fileupload.MultipartStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SimpleServer {
    private static final Logger logger = LoggerFactory.getLogger((String)SimpleServer.class.getName());
    private static final String STORAGE_DIR_PATH = "./temp/";
    private static final String LOCK_DIR_PATH = "/lock/";
    private static final String QUERY_PARAM_RESULT_TYPE = "result_type";
    private static final String QUERY_PARAM_JOB_ID = "job_id";
    private static final String CONFIG_FILE_PREFIX = "limes_server_cfg_";
    private static ConcurrentMap<Long, Integer> jobs = new ConcurrentHashMap<Long, Integer>();
    private static int limit;

    public static void startServer(int port, int limit) {
        SimpleServer.limit = limit;
        HttpServer server = null;
        logger.info("Attempting to start LIMES server at port " + port + "...");
        try {
            server = HttpServer.create(new InetSocketAddress(port), 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        server.createContext("/execute", new ExecuteHandler());
        server.createContext("/get_result", new GetResultHandler());
        server.createContext("/get_status", new GetStatusHandler());
        server.setExecutor(Executors.newCachedThreadPool());
        server.start();
        logger.info("Server has been started! Waiting for requests...");
    }

    private static void addCORSHeaders(Headers headers) {
        headers.add("Access-Control-Allow-Origin", "*");
        headers.add("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
    }

    private static Map<String, String> queryToMap(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query == null) {
            return result;
        }
        for (String param : query.split("&")) {
            try {
                param = URLDecoder.decode(param, "UTF-8");
                String[] pair = param.split("=");
                if (pair.length > 1) {
                    result.put(pair[0], pair[1]);
                    continue;
                }
                result.put(pair[0], "");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static class GetStatusHandler
    implements HttpHandler {
        private GetStatusHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            SimpleServer.addCORSHeaders(t.getResponseHeaders());
            if (t.getRequestMethod().equals("GET")) {
                Map params = SimpleServer.queryToMap(t.getRequestURI().getRawQuery());
                if (params.containsKey(SimpleServer.QUERY_PARAM_JOB_ID)) {
                    long id = Long.parseLong((String)params.get(SimpleServer.QUERY_PARAM_JOB_ID));
                    int status = -1;
                    if (new File("./temp/limes_server_cfg_" + id + ".xml").exists()) {
                        XMLConfigurationReader reader = new XMLConfigurationReader("./temp/limes_server_cfg_" + id + ".xml");
                        Configuration config = ((AConfigurationReader)reader).read();
                        String requestedFileName = config.getAcceptanceFile();
                        File requestedFile = new File(SimpleServer.STORAGE_DIR_PATH + id + "/" + requestedFileName);
                        if (jobs.containsKey(id)) {
                            status = (Integer)jobs.get(id);
                        } else if (requestedFile.exists()) {
                            status = 2;
                        }
                    }
                    byte[] response = String.valueOf(status).getBytes();
                    t.sendResponseHeaders(200, response.length);
                    OutputStream os = t.getResponseBody();
                    os.write(response);
                    os.close();
                } else {
                    t.sendResponseHeaders(400, -1L);
                    logger.info("Bad request: " + t.getRequestURI() + "\nPlease specify job_id query parameters!");
                }
            } else if (t.getRequestMethod().equals("OPTIONS")) {
                t.sendResponseHeaders(200, -1L);
                logger.info("Replied to OPTIONS request");
            } else {
                t.sendResponseHeaders(405, -1L);
                logger.info("Bad request: HTTP VERB must be GET for " + t.getRequestURI());
            }
        }
    }

    private static class GetResultHandler
    implements HttpHandler {
        private GetResultHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            SimpleServer.addCORSHeaders(t.getResponseHeaders());
            if (t.getRequestMethod().equals("GET")) {
                Map params = SimpleServer.queryToMap(t.getRequestURI().getRawQuery());
                if (params.containsKey(SimpleServer.QUERY_PARAM_JOB_ID) && params.containsKey(SimpleServer.QUERY_PARAM_RESULT_TYPE) && Arrays.asList("acceptance", "review").contains(((String)params.get(SimpleServer.QUERY_PARAM_RESULT_TYPE)).toLowerCase())) {
                    long id = Long.parseLong((String)params.get(SimpleServer.QUERY_PARAM_JOB_ID));
                    if (!new File("./temp/limes_server_cfg_" + id + ".xml").exists()) {
                        t.sendResponseHeaders(404, -1L);
                        logger.info("Bad request: " + t.getRequestURI() + "\nResource not found!");
                    } else {
                        XMLConfigurationReader reader = new XMLConfigurationReader("./temp/limes_server_cfg_" + id + ".xml");
                        Configuration config = ((AConfigurationReader)reader).read();
                        String requestedFileName = ((String)params.get(SimpleServer.QUERY_PARAM_RESULT_TYPE)).equalsIgnoreCase("acceptance") ? config.getAcceptanceFile() : config.getVerificationFile();
                        File requestedFile = new File(SimpleServer.STORAGE_DIR_PATH + id + "/" + requestedFileName);
                        File requestedFileLock = new File(SimpleServer.STORAGE_DIR_PATH + id + SimpleServer.LOCK_DIR_PATH + requestedFileName);
                        if (requestedFile.exists()) {
                            int count;
                            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
                            Collection mimeTypes = MimeUtil.getMimeTypes((File)requestedFile, (MimeType)new MimeType("text/plain"));
                            Headers headers = t.getResponseHeaders();
                            headers.add("Content-Type", mimeTypes.iterator().next().toString());
                            headers.add("Content-Disposition", "attachment; filename=" + requestedFileName);
                            t.sendResponseHeaders(200, requestedFile.length());
                            OutputStream os = t.getResponseBody();
                            FileInputStream fs = new FileInputStream(requestedFile);
                            byte[] buffer = new byte[1024];
                            while ((count = fs.read(buffer)) >= 0) {
                                os.write(buffer, 0, count);
                            }
                            os.flush();
                            fs.close();
                            os.close();
                        } else if (requestedFileLock.exists()) {
                            t.sendResponseHeaders(204, -1L);
                            logger.info("Job not yet finished: " + t.getRequestURI());
                        } else {
                            t.sendResponseHeaders(404, -1L);
                            logger.info("Bad request: " + t.getRequestURI() + "\nResource not found!");
                        }
                    }
                } else {
                    t.sendResponseHeaders(400, -1L);
                    logger.info("Bad request: " + t.getRequestURI() + "\nPlease specify job_id and result_type query parameters!");
                }
            } else if (t.getRequestMethod().equals("OPTIONS")) {
                t.sendResponseHeaders(200, -1L);
                logger.info("Replied to OPTIONS request");
            } else {
                t.sendResponseHeaders(405, -1L);
                logger.info("Bad request: HTTP VERB must be GET for " + t.getRequestURI());
            }
        }
    }

    private static class ExecuteHandler
    implements HttpHandler {
        private ExecuteHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            SimpleServer.addCORSHeaders(t.getResponseHeaders());
            if (t.getRequestMethod().equals("POST")) {
                Headers headers = t.getRequestHeaders();
                String boundary = "boundary=";
                Iterator iterator = headers.get("Content-type").iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    int i = s.indexOf(boundary);
                    if (i <= -1) continue;
                    boundary = s.substring(i + boundary.length());
                    break;
                }
                String id = this.writeConfigFile(t.getRequestBody(), boundary);
                jobs.put(Long.parseLong(id), 0);
                String response = id + "\n";
                t.sendResponseHeaders(200, response.length());
                logger.info("New Job: " + id);
                OutputStream os = t.getResponseBody();
                os.write(response.getBytes());
                os.close();
                XMLConfigurationReader reader = new XMLConfigurationReader("./temp/limes_server_cfg_" + id + ".xml");
                Configuration config = ((AConfigurationReader)reader).read();
                jobs.put(Long.parseLong(id), 1);
                ResultMappings mappings = Controller.getMapping(config, limit);
                String outputFormat = config.getOutputFormat();
                ISerializer output = SerializerFactory.createSerializer(outputFormat);
                output.setPrefixes(config.getPrefixes());
                File tempDir = new File(SimpleServer.STORAGE_DIR_PATH + id + "/");
                File lockDir = new File(tempDir + SimpleServer.LOCK_DIR_PATH);
                if (!lockDir.exists()) {
                    lockDir.mkdirs();
                }
                File _verificationFile = new File(lockDir + "/" + config.getVerificationFile());
                File _acceptanceFile = new File(lockDir + "/" + config.getAcceptanceFile());
                File verificationFile = new File(tempDir + "/" + config.getVerificationFile());
                File acceptanceFile = new File(tempDir + "/" + config.getAcceptanceFile());
                output.writeToFile(mappings.getVerificationMapping(), config.getVerificationRelation(), _verificationFile.getAbsolutePath());
                output.writeToFile(mappings.getAcceptanceMapping(), config.getAcceptanceRelation(), _acceptanceFile.getAbsolutePath());
                _verificationFile.renameTo(verificationFile);
                _acceptanceFile.renameTo(acceptanceFile);
                lockDir.delete();
                jobs.put(Long.parseLong(id), 2);
            } else if (t.getRequestMethod().equals("OPTIONS")) {
                t.sendResponseHeaders(200, -1L);
                logger.info("Replied to OPTIONS request");
            } else {
                t.sendResponseHeaders(405, -1L);
                logger.info("Bad request: HTTP VERB must be POST for " + t.getRequestURI());
            }
        }

        private String writeConfigFile(InputStream inputStream, String b) throws IOException {
            byte[] boundary = b.getBytes();
            MultipartStream multipartStream = new MultipartStream(inputStream, boundary);
            File tempDir = new File(SimpleServer.STORAGE_DIR_PATH);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File file = File.createTempFile(SimpleServer.CONFIG_FILE_PREFIX, ".xml", tempDir);
            FileOutputStream out = new FileOutputStream(file.getAbsolutePath());
            boolean nextPart = multipartStream.skipPreamble();
            if (nextPart) {
                multipartStream.readHeaders();
                multipartStream.readBodyData((OutputStream)out);
            }
            out.close();
            String id = file.getName();
            return id.substring(id.indexOf(SimpleServer.CONFIG_FILE_PREFIX) + SimpleServer.CONFIG_FILE_PREFIX.length(), id.lastIndexOf(".xml"));
        }
    }
}

