/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;

public class ResultMappings {
    protected AMapping verificationMapping;
    protected AMapping acceptanceMapping;
    private LimesStatistics statistics;

    ResultMappings() {
        this.verificationMapping = MappingFactory.createDefaultMapping();
        this.acceptanceMapping = MappingFactory.createDefaultMapping();
    }

    public ResultMappings(AMapping verificationMapping, AMapping acceptanceMapping) {
        this.verificationMapping = verificationMapping;
        this.acceptanceMapping = acceptanceMapping;
    }

    public ResultMappings(AMapping verificationMapping, AMapping acceptanceMapping, LimesStatistics statistics) {
        this(verificationMapping, acceptanceMapping);
        this.statistics = statistics;
    }

    public AMapping getVerificationMapping() {
        return this.verificationMapping;
    }

    public AMapping getAcceptanceMapping() {
        return this.acceptanceMapping;
    }

    public LimesStatistics getStatistics() {
        return this.statistics;
    }

    public static class LimesStatistics {
        private int sourceSize;
        private int targetSize;
        private long mappingTime;
        private int acceptanceSize;
        private int verificationSize;

        public LimesStatistics(int sourceSize, int targetSize, long mappingTime, int verificationSize, int acceptanceSize) {
            this.sourceSize = sourceSize;
            this.targetSize = targetSize;
            this.mappingTime = mappingTime;
            this.acceptanceSize = acceptanceSize;
            this.verificationSize = verificationSize;
        }

        public long getMappingTime() {
            return this.mappingTime;
        }

        public int getAcceptanceSize() {
            return this.acceptanceSize;
        }

        public int getVerificationSize() {
            return this.verificationSize;
        }

        public int getTargetSize() {
            return this.targetSize;
        }

        public int getSourceSize() {
            return this.sourceSize;
        }

        public String toString() {
            return String.format("{\n\t\"inputSizes\" : {\n\t\t\"source\" : %d,\n\t\t\"target\" : %d\n\t},\n\t\"mappingTime\" : %d,\n\t\"outputSizes\" : {\n\t\t\"verification\" : %d,\n\t\t\"acceptance\" : %d\n\t}\n}", this.getSourceSize(), this.getTargetSize(), this.getMappingTime(), this.getVerificationSize(), this.getAcceptanceSize());
        }
    }
}

