package org.aksw.limes.core.ml.algorithm;

import java.util.List;

import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;

/**
 * @author Tommaso Soru (tsoru@informatik.uni-leipzig.de)
 *
 */
public abstract class AMLAlgorithm {

    private ACoreMLAlgorithm coreMLAlgorithm;

    /**
     * @return the ML algorithm name
     */
    public String getName() {
        return getMl().getName();
    }
    
    /**
     * @return the associated Core ML algorithm 
     */
    public ACoreMLAlgorithm getMl() {
        return coreMLAlgorithm;
    }


    /**
     * Initialize the ML Algorithm.
     * 
     * @param lp learning parameters
     * @param source the source cache
     * @param target the target cache
     */
    public void init(List<LearningParameter> lp, ACache source, ACache target) {
        getMl().init(lp, source, target);
    }

    /**
     * Predict new links.
     * 
     * @param source the source cache
     * @param target the target cache
     * @param mlModel the ML model generated by the learning phase
     * @return the predicted mapping
     */
    public AMapping predict(ACache source, ACache target, MLResults mlModel) {
        return coreMLAlgorithm.predict(source, target, mlModel);
    }

    /**
     * @return the ML algorithm as supervised-learning algorithm 
     */
    public SupervisedMLAlgorithm asSupervised() {
        return (SupervisedMLAlgorithm) this;
    }

    /**
     * @return the ML algorithm as unsupervised-learning algorithm 
     */
    public UnsupervisedMLAlgorithm asUnsupervised() {
        return (UnsupervisedMLAlgorithm) this;
    }

    /**
     * @return the ML algorithm as active-learning algorithm 
     */
    public ActiveMLAlgorithm asActive() {
        return (ActiveMLAlgorithm) this;
    }

    /**
     * @return the learning parameters
     */
    public List<LearningParameter> getParameters() {
        return getMl().getParameters();
    }

    /**
     * @param ml the core ML algorithm
     */
    public void setMl(ACoreMLAlgorithm ml) {
        this.coreMLAlgorithm = ml;
    }

	/**
	 * @param par parameter name
	 * @param val parameter value
	 */
	public void setParameter(String par, Object val) {
	    coreMLAlgorithm.setParameter(par, val);
	}

}
