/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.string.fastngram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.string.fastngram.Index;
import org.aksw.limes.core.measures.mapper.string.fastngram.NGramTokenizer;
import org.aksw.limes.core.measures.measure.string.QGramSimilarityMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class FastNGramMapper
extends AMapper {
    static Logger logger = LoggerFactory.getLogger(FastNGramMapper.class);
    static int q = 3;

    public static AMapping compute(Set<String> source, Set<String> target, int q, double threshold) {
        Index index = new Index(q);
        double kappa = (1.0 + threshold) / threshold;
        QGramSimilarityMeasure sim = new QGramSimilarityMeasure(q);
        NGramTokenizer tokenizer = new NGramTokenizer();
        HashMap<String, Set<String>> targetTokens = new HashMap<String, Set<String>>();
        AMapping result = MappingFactory.createDefaultMapping();
        for (String t : target) {
            targetTokens.put(t, index.addString(t));
        }
        for (String s : source) {
            Set<Integer> allSizes = index.getAllSizes();
            Set<String> sourceTokens = tokenizer.tokenize(s, q);
            double sourceSize = sourceTokens.size();
            for (int size = (int)Math.ceil(sourceSize * threshold); size <= (int)Math.floor(sourceSize / threshold); ++size) {
                if (!allSizes.contains(size)) continue;
                Map<String, Set<String>> stringsOfSize = index.getStrings(size);
                HashMap<String, Integer> countMap = new HashMap<String, Integer>();
                for (String token : sourceTokens) {
                    if (!stringsOfSize.containsKey(token)) continue;
                    Set<String> candidates = stringsOfSize.get(token);
                    for (String candidate : candidates) {
                        if (!countMap.containsKey(candidate)) {
                            countMap.put(candidate, 0);
                        }
                        countMap.put(candidate, (Integer)countMap.get(candidate) + 1);
                    }
                }
                for (String candidate : countMap.keySet()) {
                    double similarity;
                    double count = ((Integer)countMap.get(candidate)).intValue();
                    if (!(kappa * count >= sourceSize + (double)size) || !((similarity = sim.getSimilarity((Set)targetTokens.get(candidate), sourceTokens)) >= threshold)) continue;
                    result.add(s, candidate, similarity);
                }
            }
        }
        AMapping tempMapping = MappingFactory.createDefaultMapping();
        for (String key : result.getMap().keySet()) {
            for (String value : result.getMap().get(key).keySet()) {
                double confidence = result.getConfidence(key, value);
                if (!(confidence >= threshold)) continue;
                tempMapping.add(key, value, confidence);
            }
        }
        result = tempMapping;
        return result;
    }

    @Override
    public String getName() {
        return "FastNGram";
    }

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        TreeSet<String> values;
        int i;
        String var;
        String[] split;
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        String property1 = null;
        String property2 = null;
        Parser p = new Parser(expression, threshold);
        String term1 = "?" + p.getLeftTerm();
        String term2 = "?" + p.getRightTerm();
        String property = "";
        if (term1.contains(".")) {
            split = term1.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i = 2; i < split.length; ++i) {
                    property = property + "." + split[i];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property1 = term1;
        }
        if (term2.contains(".")) {
            split = term2.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i = 2; i < split.length; ++i) {
                    property = property + "." + split[i];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property2 = term2;
        }
        if (property1 == null || property2 == null) {
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Property 1 = " + property1 + ", Property 2 = " + property2);
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Property values could not be read. Exiting");
            throw new RuntimeException();
        }
        if (!p.isAtomic()) {
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Mappers can only deal with atomic expression");
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Expression " + expression + " was given to a mapper to process");
            throw new RuntimeException();
        }
        HashMap sourceMap = new HashMap();
        ArrayList<String> sourceUris = source.getAllUris();
        HashMap targetMap = new HashMap();
        ArrayList<String> targetUris = target.getAllUris();
        for (String s : sourceUris) {
            values = source.getInstance(s).getProperty(property1);
            for (String v : values) {
                if (!sourceMap.containsKey(v)) {
                    sourceMap.put(v, new HashSet());
                }
                ((Set)sourceMap.get(v)).add(s);
            }
        }
        for (String t : targetUris) {
            values = target.getInstance(t).getProperty(property2);
            for (String v : values) {
                if (!targetMap.containsKey(v)) {
                    targetMap.put(v, new HashSet());
                }
                ((Set)targetMap.get(v)).add(t);
            }
        }
        AMapping m = FastNGramMapper.compute(sourceMap.keySet(), targetMap.keySet(), q, threshold);
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : m.getMap().keySet()) {
            for (String t : m.getMap().get(s).keySet()) {
                for (String sourceUri : (Set)sourceMap.get(s)) {
                    for (String targetUri : (Set)targetMap.get(t)) {
                        result.add(sourceUri, targetUri, m.getConfidence(s, t));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 492.9 + 0.09 * (double)sourceSize + 0.09 * (double)targetSize - 1032.3 * threshold;
        }
        return 59.82 + 0.01 * (double)sourceSize + 0.01 * (double)targetSize - 114.2 * threshold;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 727.2 + 0.063 * (double)sourceSize + 0.063 * (double)targetSize - 1305.1 * threshold;
        }
        return 8.2 + 0.001 * (double)sourceSize + 0.001 * (double)targetSize - 16.75 * threshold;
    }
}

