/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.OrthodromicDistance;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonIndex {
    static Logger logger = LoggerFactory.getLogger(PolygonIndex.class);
    public Map<String, Map<Point, Map<Point, Double>>> distanceIndex = new HashMap<String, Map<Point, Map<Point, Double>>>();
    public Map<String, Polygon> polygonIndex = new HashMap<String, Polygon>();
    public int computations = 0;

    public String toString() {
        return this.distanceIndex.toString();
    }

    public void index(Set<Polygon> polygons) {
        for (Polygon x : polygons) {
            this.index(x);
        }
    }

    public void index(Polygon p) {
        HashMap index = new HashMap();
        for (int i = 0; i < p.points.size(); ++i) {
            HashMap<Point, Double> distances = new HashMap<Point, Double>();
            for (int j = i + 1; j < p.points.size(); ++j) {
                distances.put(p.points.get(j), OrthodromicDistance.getDistanceInDegrees(p.points.get(i), p.points.get(j)));
                ++this.computations;
            }
            index.put(p.points.get(i), distances);
        }
        this.distanceIndex.put(p.uri, index);
        this.polygonIndex.put(p.uri, p);
    }

    public double getDistance(String uri, Point x, Point y) {
        if (x.equals(y)) {
            return 0.0;
        }
        if (this.polygonIndex.containsKey(uri)) {
            try {
                if (this.distanceIndex.get(uri).get(x).containsKey(y)) {
                    return this.distanceIndex.get(uri).get(x).get(y);
                }
                return this.distanceIndex.get(uri).get(y).get(x);
            }
            catch (Exception e) {
                logger.warn("Error for uri" + uri + "\t Index contains uri = " + this.distanceIndex.containsKey(uri) + "\nx = " + x + "\ty = " + y);
                return OrthodromicDistance.getDistanceInDegrees(x, y);
            }
        }
        logger.warn(uri + "\t Index contains uri = " + this.polygonIndex.containsKey(uri));
        if (this.distanceIndex.containsKey(uri)) {
            logger.warn(uri + "\t Distance index contains " + x + " = " + this.distanceIndex.get(uri).containsKey(x));
            logger.warn(uri + "\t Distance index contains " + x + " = " + this.distanceIndex.get(uri).containsKey(y));
        }
        return OrthodromicDistance.getDistanceInDegrees(x, y);
    }
}

