/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.mapping.reader;

import org.aksw.limes.core.io.config.reader.rdf.RDFConfigurationReader;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.mapping.reader.AMappingReader;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class RDFMappingReader
extends AMappingReader {
    public RDFMappingReader(String file) {
        super(file);
    }

    @Override
    public AMapping read() {
        AMapping mapping = MappingFactory.createDefaultMapping();
        Model mappingModel = RDFConfigurationReader.readModel(this.file);
        StmtIterator iter = mappingModel.listStatements();
        while (iter.hasNext()) {
            Statement stmt = iter.nextStatement();
            mapping.add(stmt.getSubject().toString(), stmt.getObject().toString(), 1.0);
            mapping.setPredicate(stmt.getPredicate().toString());
        }
        return mapping;
    }
}

