/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.planner;

import org.aksw.limes.core.execution.planning.planner.CanonicalPlanner;
import org.aksw.limes.core.execution.planning.planner.DynamicPlanner;
import org.aksw.limes.core.execution.planning.planner.HeliosPlanner;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.io.cache.ACache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionPlannerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionPlannerFactory.class);
    public static final String DEFAULT = "default";
    public static final String CANONICAL = "canonical";
    public static final String HELIOS = "helios";
    public static final String DYNAMIC = "dynamic";

    public static ExecutionPlannerType getExecutionPlannerType(String name) {
        if (name.equalsIgnoreCase(DEFAULT)) {
            return ExecutionPlannerType.DEFAULT;
        }
        if (name.equalsIgnoreCase(CANONICAL)) {
            return ExecutionPlannerType.CANONICAL;
        }
        if (name.equalsIgnoreCase(DYNAMIC)) {
            return ExecutionPlannerType.DYNAMIC;
        }
        if (name.equalsIgnoreCase(HELIOS)) {
            return ExecutionPlannerType.HELIOS;
        }
        logger.warn("Sorry, " + name + " is not yet implemented. Returning the default planner type instead...");
        return ExecutionPlannerType.HELIOS;
    }

    public static Planner getPlanner(ExecutionPlannerType type, ACache source, ACache target) {
        switch (type) {
            case DEFAULT: {
                return new CanonicalPlanner();
            }
            case CANONICAL: {
                return new CanonicalPlanner();
            }
            case HELIOS: {
                return new HeliosPlanner(source, target);
            }
            case DYNAMIC: {
                return new DynamicPlanner(source, target);
            }
        }
        logger.warn("Sorry, " + type.toString() + " is not yet implemented. Returning the default planner instead...");
        return new CanonicalPlanner();
    }

    public static enum ExecutionPlannerType {
        DEFAULT,
        CANONICAL,
        HELIOS,
        DYNAMIC;

    }
}

