/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoPrecision;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoRefPrecision
extends PseudoPrecision {
    static Logger logger = LoggerFactory.getLogger(PseudoRefPrecision.class);

    @Override
    public double calculate(AMapping predictions, GoldStandard goldStandard) {
        AMapping res = predictions;
        if (this.useOneToOneMapping) {
            res = predictions.getBestOneToOneMappings(predictions);
        }
        double p = res.getMap().keySet().size();
        double q = 0.0;
        for (String s : res.getMap().keySet()) {
            q += (double)res.getMap().get(s).size();
        }
        if (p == 0.0 || q == 0.0) {
            return 0.0;
        }
        return p / q;
    }
}

