/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm;

public class LearningParameter {
    protected String name;
    protected Object value;
    protected Class<?> clazz;
    protected double rangeStart;
    protected double rangeEnd;
    protected double rangeStep;
    protected String description;

    public LearningParameter() {
    }

    public LearningParameter(String name, Object value) {
        this();
        this.name = name;
        this.value = value;
    }

    public LearningParameter(String name, Object value, Class<?> clazz, double rangeStart, double rangeEnd, double rangeStep, String description) {
        this(name, value);
        this.clazz = clazz;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.rangeStep = rangeStep;
        this.description = description;
    }

    public double getRangeStep() {
        return this.rangeStep;
    }

    public void setRangeStep(double rangeStep) {
        this.rangeStep = rangeStep;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public double getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(double rangeStart) {
        this.rangeStart = rangeStart;
    }

    public double getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(double rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        long temp = Double.doubleToLongBits(this.rangeEnd);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rangeStart);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rangeStep);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LearningParameter other = (LearningParameter)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rangeEnd) != Double.doubleToLongBits(other.rangeEnd)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rangeStart) != Double.doubleToLongBits(other.rangeStart)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rangeStep) != Double.doubleToLongBits(other.rangeStep)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.toString().equals(other.value.toString()));
    }
}

