/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import java.util.TreeSet;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.StringMeasure;

public class TrigramMeasure
extends StringMeasure {
    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        return 2.0 * (double)overlap / (double)(lengthA + lengthB);
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double sim = 0.0;
        double max = 0.0;
        for (String p1 : instance1.getProperty(property1)) {
            for (String p2 : instance2.getProperty(property2)) {
                sim = this.getSimilarity(p1, p2);
                if (!(max < sim)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "Trigram";
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        String p1 = "  " + object1 + "  ";
        String p2 = "  " + object2 + "  ";
        if (p1.length() == 4 && p2.length() == 4) {
            return 1.0;
        }
        if (p1.length() == 4 && p2.length() > 4 || p2.length() == 4 && p1.length() > 4) {
            return 0.0;
        }
        TreeSet<String> t1 = this.getTrigrams(p1);
        TreeSet<String> t2 = this.getTrigrams(p2);
        double counter = 0.0;
        for (String s : t1) {
            if (!t2.contains(s)) continue;
            counter += 1.0;
        }
        return 2.0 * counter / (double)(t1.size() + t2.size());
    }

    public TreeSet<String> getTrigrams(String a) {
        TreeSet<String> result = new TreeSet<String>();
        String copy = a;
        for (int i = 2; i < copy.length(); ++i) {
            result.add(copy.substring(i - 2, i));
        }
        return result;
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)tokensNumber * threshold / (2.0 - threshold))) + k;
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)tokensNumber * threshold)) + k;
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        return threshold / (2.0 - threshold) * (double)tokensNumber;
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        return (int)Math.ceil((float)(threshold / 2.0 * (double)(xTokensNumber + yTokensNumber)));
    }

    @Override
    public boolean computableViaOverlap() {
        return true;
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

