/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import java.util.TreeSet;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.StringMeasure;

public class OverlapMeasure
extends StringMeasure {
    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        return (int)((double)tokensNumber - threshold + 1.0);
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        return Integer.MAX_VALUE;
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        return threshold;
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        return (int)threshold;
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        return overlap;
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        double counter = 0.0;
        TreeSet<String> tokens1 = new TreeSet<String>();
        TreeSet<String> tokens2 = new TreeSet<String>();
        String[] split1 = ((String)object1).split(" ");
        for (int i = 0; i < split1.length; ++i) {
            tokens1.add(split1[i]);
        }
        String[] split2 = ((String)object2).split(" ");
        for (int i = 0; i < split2.length; ++i) {
            tokens2.add(split2[i]);
        }
        for (String s : tokens2) {
            if (!tokens1.contains(s)) continue;
            counter += 1.0;
        }
        return counter;
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double max = 0.0;
        for (String p1 : instance1.getProperty(property1)) {
            for (String p2 : instance2.getProperty(property2)) {
                double sim = this.getSimilarity(p1, p2);
                if (!(sim > max)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "overlap";
    }

    @Override
    public boolean computableViaOverlap() {
        return true;
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

