/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.space;

import org.aksw.limes.core.measures.measure.space.AMinkowskiMeasure;

public class EuclideanMeasure
extends AMinkowskiMeasure {
    @Override
    double outerPTerm(double sum) {
        return Math.sqrt(sum);
    }

    @Override
    double innerPTerm(String xi, String yi) {
        double d = new Double(xi) - new Double(xi);
        return d * d;
    }

    @Override
    public String getName() {
        return "euclidean";
    }

    @Override
    public double getThreshold(int dimension, double simThreshold) {
        return (1.0 - simThreshold) / simThreshold;
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

