/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.frechet;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.OrchidMapper;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;
import org.aksw.limes.core.measures.measure.pointsets.frechet.PolygonFrechetDistance;

public class NaiveFrechetMeasure
extends APointsetsMeasure {
    static GeometricShapeFactory gsf = new GeometricShapeFactory();
    static GeometryFactory gf = new GeometryFactory();
    static double delta = 0.01;
    public double[][] a;
    public double[][] b;
    public double[][] c;
    public double[][] d;
    public int computations = 0;
    Polygon poly1;
    Polygon poly2;

    public static double distance(Polygon X, Polygon Y, double threshold) {
        return new NaiveFrechetMeasure().computeDistance(X, Y, threshold);
    }

    @Override
    public double computeDistance(Polygon X, Polygon Y, double threshold) {
        PolygonFrechetDistance frechetDistance = new PolygonFrechetDistance(X, Y);
        return frechetDistance.computeFrechetDistance();
    }

    @Override
    public String getName() {
        return "naiveFrechet";
    }

    @Override
    public AMapping run(Set<Polygon> source, Set<Polygon> target, double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        for (Polygon s : source) {
            for (Polygon t : target) {
                double d = this.computeDistance(s, t, threshold);
                if (!(d <= threshold)) continue;
                m.add(s.uri, t.uri, d);
            }
        }
        return m;
    }

    @Override
    public String getType() {
        return "geodistance";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        TreeSet<String> source = instance1.getProperty(property1);
        TreeSet<String> target = instance2.getProperty(property2);
        HashSet<Polygon> sourcePolygons = new HashSet<Polygon>();
        HashSet<Polygon> targetPolygons = new HashSet<Polygon>();
        for (String s : source) {
            sourcePolygons.add(OrchidMapper.getPolygon(s));
        }
        for (String t : target) {
            targetPolygons.add(OrchidMapper.getPolygon(t));
        }
        double min = Double.MAX_VALUE;
        double d = 0.0;
        for (Polygon p1 : sourcePolygons) {
            for (Polygon p2 : targetPolygons) {
                d = this.computeDistance(p1, p2, 0.0);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return 1.0 / (1.0 + d);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

