/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.h2.CacheUtilsH2;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceReference;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.preprocessing.Preprocessor;
import org.aksw.limes.core.io.query.IQueryModule;
import org.aksw.limes.core.io.query.SparqlQueryModule;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.DatasetDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilientSparqlQueryModule
extends SparqlQueryModule
implements IQueryModule {
    protected Logger logger = LoggerFactory.getLogger(ResilientSparqlQueryModule.class);
    protected int retryCount = 5;
    protected int retryDelayInMS = 500;
    protected int requestDelayInMs = 50;
    protected int pageSize = 900;
    protected long timeToLive = 86400000L;
    protected String cacheDirectory = System.getProperty("user.dir") + "/cache";

    public ResilientSparqlQueryModule(KBInfo kbInfo) {
        super(kbInfo);
    }

    public ResilientSparqlQueryModule(KBInfo kbinfo, Logger logger, int retryCount, int retryDelayInMS, int requestDelayInMs, int pageSize, long timeToLive, String cacheDirectory) {
        super(kbinfo);
        this.logger = logger;
        this.retryCount = retryCount;
        this.retryDelayInMS = retryDelayInMS;
        this.requestDelayInMs = requestDelayInMs;
        this.pageSize = pageSize;
        this.timeToLive = timeToLive;
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public void fillCache(ACache cache, boolean sparql) {
        long startTime = System.currentTimeMillis();
        String query = this.generateQuery();
        this.logger.info("Querying the endpoint.");
        QueryExecutionFactory qef = null;
        try {
            qef = this.initQueryExecution(this.kb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QueryExecution qe = qef.createQueryExecution(query);
        int counter = 0;
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            try {
                String uri = soln.get(this.kb.getVar().substring(1)).toString();
                for (int i = 0; i < this.kb.getProperties().size(); ++i) {
                    String propertyLabel = this.kb.getProperties().get(i);
                    if (!soln.contains("v" + i)) continue;
                    String rawValue = soln.get("v" + i).toString();
                    for (String propertyDub : this.kb.getFunctions().get(propertyLabel).keySet()) {
                        String value = Preprocessor.process(rawValue, this.kb.getFunctions().get(propertyLabel).get(propertyDub));
                        cache.addTriple(uri, propertyDub, value);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Error while processing: " + soln.toString());
                this.logger.warn("Following exception occured: " + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException();
            }
            ++counter;
        }
        this.logger.info("Retrieved " + counter + " triples and " + cache.size() + " entities.");
        this.logger.info("Retrieving statements took " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }

    protected QueryExecutionFactory initQueryExecution(KBInfo kbInfo) throws ClassNotFoundException, SQLException {
        DatasetDescription dd = new DatasetDescription();
        if (kbInfo.getGraph() != null) {
            dd.addDefaultGraphURI(kbInfo.getGraph());
        }
        SparqlServiceReference ssr = new SparqlServiceReference(kbInfo.getEndpoint(), dd);
        QueryExecutionFactory qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((SparqlServiceReference)ssr).config().withRetry(this.retryCount, (long)this.retryDelayInMS, TimeUnit.MILLISECONDS).withDelay(this.requestDelayInMs, TimeUnit.MILLISECONDS).withPagination(this.pageSize).end()).create();
        if (this.cacheDirectory != null) {
            String dbName = kbInfo.getEndpoint().replaceAll("[:/]", "_");
            CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend((String)dbName, (boolean)true, (long)this.timeToLive);
            qef = new QueryExecutionFactoryCacheEx(qef, cacheFrontend);
        } else {
            this.logger.info("The cache directory has not been set. Creating an uncached SPARQL client.");
        }
        try {
            qef = new QueryExecutionFactoryPaginated(qef, (long)this.pageSize);
            return qef;
        }
        catch (Exception e) {
            this.logger.warn("Couldn't create Factory with pagination. Returning Factory without pagination. Exception: " + e.getLocalizedMessage());
            return qef;
        }
    }
}

