/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.IQueryModule;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoPrefixSparqlQueryModule
implements IQueryModule {
    KBInfo kb;

    public NoPrefixSparqlQueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillCache(ACache cache) {
        int i;
        Logger logger = LoggerFactory.getLogger((String)"LIMES");
        long startTime = System.currentTimeMillis();
        String query = "";
        query = query + "SELECT DISTINCT " + this.kb.getVar();
        for (int i2 = 0; i2 < this.kb.getProperties().size(); ++i2) {
            query = query + " ?v" + i2;
        }
        query = query + "\n";
        if (this.kb.getRestrictions().size() > 0) {
            this.kb.getRestrictions().iterator();
            query = query + "WHERE {\n";
            for (i = 0; i < this.kb.getRestrictions().size(); ++i) {
                String where = this.kb.getRestrictions().get(i);
                query = query + where + " .\n";
            }
        }
        query = query + "OPTIONAL {";
        if (this.kb.getProperties().size() > 0) {
            logger.info("Properties are " + this.kb.getProperties());
            String optional = "";
            for (i = 0; i < this.kb.getProperties().size(); ++i) {
                optional = optional + this.kb.getVar() + " <" + this.kb.getProperties().get(i) + "> ?v" + i + " .\n";
            }
            query = query + optional;
        }
        query = query + "}";
        if (this.kb.getRestrictions().size() > 0) {
            query = query + "}\n";
        }
        logger.info("Query issued is \n" + query);
        logger.info("Querying the endpoint.");
        int offset = 0;
        boolean moreResults = false;
        int counter = 0;
        String basicQuery = query;
        do {
            logger.info("Getting statements " + offset + " to " + (offset + this.kb.getPageSize()));
            if (this.kb.getPageSize() > 0) {
                query = basicQuery + " LIMIT " + this.kb.getPageSize() + " OFFSET " + offset;
            }
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.kb.getEndpoint(), (Query)sparqlQuery);
            logger.info("No default graph " + this.kb.getGraph());
            ResultSet results = qexec.execSelect();
            try {
                if (results.hasNext()) {
                    moreResults = true;
                } else {
                    moreResults = false;
                    break;
                }
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    try {
                        String uri = soln.get(this.kb.getVar().substring(1)).toString();
                        for (int i3 = 0; i3 < this.kb.getProperties().size(); ++i3) {
                            String property = this.kb.getProperties().get(i3);
                            if (soln.contains("v" + i3)) {
                                String value = soln.get("v" + i3).toString();
                                if (value.contains("@")) {
                                    value = value.substring(0, value.indexOf("@"));
                                }
                                if (value.contains("^^")) {
                                    if (value.contains(":date")) {
                                        if ((value = value.substring(0, value.indexOf("^^"))).contains(" ")) {
                                            value = value.substring(0, value.indexOf(" "));
                                        }
                                        String[] split = value.split("-");
                                        value = Integer.parseInt(split[0]) * 365 + Integer.parseInt(split[1]) * 12 + Integer.parseInt(split[2]) + "";
                                    } else {
                                        value = value.substring(0, value.indexOf("^^"));
                                    }
                                }
                                cache.addTriple(uri, property, value);
                                continue;
                            }
                            cache.addTriple(uri, property, "");
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Error while processing: " + soln.toString());
                        logger.warn("Following exception occured: " + e.getMessage());
                        logger.info("Processing further ...");
                    }
                    ++counter;
                }
            }
            catch (Exception e) {
                logger.warn("Exception while handling query");
                logger.warn(e.toString());
                logger.warn("XML = \n" + ResultSetFormatter.asXMLString((ResultSet)results));
            }
            finally {
                qexec.close();
            }
            offset += this.kb.getPageSize();
        } while (moreResults && this.kb.getPageSize() > 0);
        logger.info("Retrieved " + counter + " triples and " + cache.size() + " entities.");
        logger.info("Retrieving statements took " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }
}

