/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.util.RandomStringGenerator;

public class MemoryMapping
extends AMapping {
    private static final long serialVersionUID = 2763300329497546833L;

    protected MemoryMapping() {
    }

    public static AMapping generateRandomMapping(int mappingSize, int minSize, int maxSize) {
        AMapping m = MappingFactory.createDefaultMapping();
        RandomStringGenerator generator = new RandomStringGenerator(minSize, maxSize);
        while (m.getNumberofMappings() < mappingSize) {
            m.add(generator.generateString(), generator.generateString(), Math.random());
        }
        return m;
    }

    public void initReversedMap() {
        this.reversedMap = new HashMap();
        for (String s : this.map.keySet()) {
            for (String t : ((HashMap)this.map.get(s)).keySet()) {
                double sim = (Double)((HashMap)this.map.get(s)).get(t);
                if (!this.reversedMap.containsKey(sim)) {
                    this.reversedMap.put(sim, new HashMap());
                }
                if (!((HashMap)this.reversedMap.get(sim)).containsKey(s)) {
                    ((HashMap)this.reversedMap.get(sim)).put(s, new TreeSet());
                }
                ((TreeSet)((HashMap)this.reversedMap.get(sim)).get(s)).add(t);
            }
        }
    }

    @Override
    public AMapping getSubMap(double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        if (this.reversedMap == null || this.reversedMap.size() == 0) {
            this.initReversedMap();
        }
        for (Double d : this.reversedMap.keySet()) {
            if (!(d >= threshold)) continue;
            HashMap pairs = (HashMap)this.reversedMap.get(d);
            for (String s : pairs.keySet()) {
                for (String t : (TreeSet)pairs.get(s)) {
                    m.add(s, t, d);
                }
            }
        }
        return m;
    }

    @Override
    public void add(String uri, HashMap<String, Double> instances) {
        if (!this.map.containsKey(uri)) {
            this.map.put(uri, instances);
            this.size += instances.size();
        } else {
            for (String mappingUri : instances.keySet()) {
                this.add(uri, mappingUri, instances.get(mappingUri));
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(String source, String target, double similarity) {
        if (this.map.containsKey(source)) {
            if (((HashMap)this.map.get(source)).containsKey(target)) {
                if (similarity > (Double)((HashMap)this.map.get(source)).get(target)) {
                    ((HashMap)this.map.get(source)).put(target, similarity);
                }
            } else {
                ((HashMap)this.map.get(source)).put(target, similarity);
                ++this.size;
            }
        } else {
            HashMap<String, Double> help = new HashMap<String, Double>();
            help.put(target, similarity);
            this.map.put(source, help);
            ++this.size;
        }
    }

    @Override
    public double getConfidence(String sourceInstance, String targetInstance) {
        if (this.map.containsKey(sourceInstance) && ((HashMap)this.map.get(sourceInstance)).containsKey(targetInstance)) {
            return (Double)((HashMap)this.map.get(sourceInstance)).get(targetInstance);
        }
        return 0.0;
    }

    @Override
    public boolean contains(String sourceInstance, String targetInstance) {
        return this.map.containsKey(sourceInstance) && ((HashMap)this.map.get(sourceInstance)).containsKey(targetInstance);
    }

    public String toString() {
        String s = "";
        for (String key : this.map.keySet()) {
            for (String value : ((HashMap)this.map.get(key)).keySet()) {
                s = s + "[" + key + " -> (" + value + "|" + ((HashMap)this.map.get(key)).get(value) + ")]\n";
            }
        }
        return s;
    }

    @Override
    public int getNumberofMappings() {
        int size = 0;
        for (String s : this.map.keySet()) {
            HashMap m = (HashMap)this.map.get(s);
            size += m.size();
        }
        return size;
    }

    @Override
    public AMapping getBestOneToNMapping() {
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : this.map.keySet()) {
            double maxSim = 0.0;
            HashSet<String> target = new HashSet<String>();
            for (String t : ((HashMap)this.map.get(s)).keySet()) {
                if (this.getConfidence(s, t) == maxSim) {
                    target.add(t);
                }
                if (!(this.getConfidence(s, t) > maxSim)) continue;
                maxSim = this.getConfidence(s, t);
                target = new HashSet();
                target.add(t);
            }
            for (String t : target) {
                result.add(s, t, maxSim);
            }
        }
        return result;
    }

    @Override
    public AMapping reverseSourceTarget() {
        AMapping m = MappingFactory.createDefaultMapping();
        for (String s : this.map.keySet()) {
            for (String t : ((HashMap)this.map.get(s)).keySet()) {
                m.add(t, s, (Double)((HashMap)this.map.get(s)).get(t));
            }
        }
        return m;
    }

    public AMapping scale(double d) {
        if (d != 0.0) {
            AMapping m = MappingFactory.createDefaultMapping();
            for (String s : this.map.keySet()) {
                for (String t : ((HashMap)this.map.get(s)).keySet()) {
                    m.add(s, t, (Double)((HashMap)this.map.get(s)).get(t) / d);
                }
            }
            return m;
        }
        return this;
    }

    public AMapping trim() {
        AMapping m = MappingFactory.createDefaultMapping();
        for (String s : this.map.keySet()) {
            for (String t : ((HashMap)this.map.get(s)).keySet()) {
                if ((Double)((HashMap)this.map.get(s)).get(t) > 1.0) {
                    m.add(s, t, 1.0);
                    continue;
                }
                m.add(s, t, (Double)((HashMap)this.map.get(s)).get(t));
            }
        }
        return m;
    }

    public String pairsOutput() {
        String s = "";
        for (String key : this.map.keySet()) {
            for (String value : ((HashMap)this.map.get(key)).keySet()) {
                s = s + key + "," + value + "\n";
            }
        }
        return s;
    }

    public AMapping union(AMapping other) {
        AMapping result = MappingFactory.createDefaultMapping();
        result.map.putAll(this.map);
        result.size = this.size();
        for (String s : other.map.keySet()) {
            result.add(s, other.map.get(s));
        }
        return result;
    }
}

