/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;

public class KBInfo
implements Serializable {
    private static final String DEFAULT_QUERY_TYPE = "sparql";
    private static final long serialVersionUID = 7915400434442160847L;
    protected String id;
    protected String endpoint;
    protected String graph;
    protected String var;
    protected List<String> properties;
    protected List<String> optionalProperties;
    protected ArrayList<String> restrictions;
    protected Map<String, Map<String, String>> functions;
    protected Map<String, String> prefixes;
    protected int pageSize;
    protected String type;
    protected int maxoffset;
    protected int minoffset;

    public KBInfo() {
        this.id = null;
        this.endpoint = null;
        this.graph = null;
        this.restrictions = new ArrayList();
        this.properties = new ArrayList<String>();
        this.optionalProperties = new ArrayList<String>();
        this.prefixes = new HashMap<String, String>();
        this.functions = new HashMap<String, Map<String, String>>();
        this.pageSize = -1;
        this.type = DEFAULT_QUERY_TYPE;
        this.maxoffset = -1;
        this.minoffset = -1;
    }

    public KBInfo(String var) {
        this();
        this.var = var;
    }

    public KBInfo(String id, String endpoint, String graph, String var, List<String> properties, List<String> optionalProperties, ArrayList<String> restrictions, Map<String, Map<String, String>> functions, Map<String, String> prefixes, int pageSize, String type) {
        this.id = id;
        this.endpoint = endpoint;
        this.graph = graph;
        this.var = var;
        this.properties = properties;
        this.optionalProperties = optionalProperties;
        this.restrictions = restrictions;
        this.functions = functions;
        this.prefixes = prefixes;
        this.pageSize = pageSize;
        this.type = type;
    }

    public KBInfo(String id, String endpoint, String graph, String var, List<String> properties, List<String> optionalProperties, ArrayList<String> restrictions, Map<String, Map<String, String>> functions, Map<String, String> prefixes, int pageSize, String type, int minoffset, int maxoffset) {
        this(id, endpoint, graph, var, properties, optionalProperties, restrictions, functions, prefixes, pageSize, type);
        this.maxoffset = maxoffset;
        this.minoffset = minoffset;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getGraph() {
        return this.graph;
    }

    public void setGraph(String graph) {
        this.graph = graph;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public List<String> getOptionalProperties() {
        return this.optionalProperties;
    }

    public void setOptionalProperties(List<String> optionalProperties) {
        this.optionalProperties = optionalProperties;
    }

    public ArrayList<String> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(ArrayList<String> restrictions) {
        this.restrictions = restrictions;
    }

    public void addRestriction(String restriction) {
        this.restrictions.add(restriction);
    }

    public void addProperty(String property) {
        this.properties.add(property);
    }

    public void addOptionalProperty(String optionalProperty) {
        this.optionalProperties.add(optionalProperty);
    }

    public Map<String, Map<String, String>> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Map<String, Map<String, String>> functions) {
        this.functions = functions;
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public void setPrefixes(Map<String, String> prefixes) {
        this.prefixes = prefixes;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMaxOffset(int maxoffset) {
        this.maxoffset = maxoffset;
    }

    public int getMaxOffset() {
        return this.maxoffset;
    }

    public void setMinOffset(int minoffset) {
        this.minoffset = minoffset;
    }

    public int getMinOffset() {
        return this.minoffset;
    }

    public String toString() {
        String s = "ID: " + this.id + "\n";
        s = s + "Var: " + this.var + "\n";
        s = s + "Prefixes: " + this.prefixes + "\n";
        s = s + "Endpoint: " + this.endpoint + "\n";
        s = s + "Graph: " + this.graph + "\n";
        s = s + "Restrictions: " + this.restrictions + "\n";
        s = s + "Properties: " + this.properties + "\n";
        s = s + "OptionalProperties: " + this.optionalProperties + "\n";
        s = s + "Functions: " + this.functions + "\n";
        s = s + "Page size: " + this.pageSize + "\n";
        s = s + "Type: " + this.type + "\n";
        s = s + "MinOffset: " + this.minoffset + "\n";
        s = s + "MaxOffset: " + this.maxoffset + "\n";
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.pageSize;
        result = 31 * result + (this.prefixes == null ? 0 : this.prefixes.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.maxoffset;
        result = 31 * result + this.minoffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KBInfo other = (KBInfo)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.graph == null ? other.graph != null : !this.graph.equals(other.graph)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        if (this.maxoffset != other.maxoffset) {
            return false;
        }
        if (this.minoffset != other.minoffset) {
            return false;
        }
        if (this.prefixes == null ? other.prefixes != null : !this.prefixes.equals(other.prefixes)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.restrictions == null ? other.restrictions != null : !this.restrictions.equals(other.restrictions)) {
            return false;
        }
        return !(this.var == null ? other.var != null : !this.var.equals(other.var));
    }

    public String getClassOfendpoint() {
        for (String rest : this.restrictions) {
            if (!rest.matches(".* rdf:type .*")) continue;
            String result = rest.substring(rest.indexOf("rdf:type") + 8).replaceAll("<", "").replaceAll(">", "").trim();
            return result;
        }
        return null;
    }

    public String getClassOfendpoint(boolean expanded) {
        for (String rest : this.restrictions) {
            if (!rest.matches(".* rdf:type .*")) continue;
            String result = rest.substring(rest.indexOf("rdf:type") + 8).replaceAll("<", "").replaceAll(">", "").trim();
            if (!expanded) {
                return result;
            }
            String namespace = result.substring(0, result.indexOf(":"));
            if (this.prefixes.containsKey(namespace)) {
                return this.prefixes.get(namespace) + result.substring(result.indexOf(":") + 1);
            }
            return result;
        }
        return null;
    }

    public String getClassRestriction() {
        String ret = null;
        for (String s : this.restrictions) {
            if (s.indexOf("rdf:type") <= -1) continue;
            ret = s.substring(s.indexOf("rdf:type") + 8).trim();
        }
        return ret;
    }

    public String getPrefix(String baseUri) {
        if (this.prefixes.containsValue(baseUri)) {
            for (Map.Entry<String, String> e : this.prefixes.entrySet()) {
                if (!e.getValue().equals(baseUri)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    public void afterPropertiesSet() {
        ArrayList<String> copy = new ArrayList<String>(this.properties);
        this.properties.clear();
        for (String property : copy) {
            XMLConfigurationReader.processProperty(this, property);
        }
    }
}

