/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.preprocessing.Preprocessor;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache
extends ACache {
    private static final Logger logger = LoggerFactory.getLogger(MemoryCache.class);
    protected HashMap<String, Instance> instanceMap = new HashMap();
    protected Iterator<Instance> instanceIterator;

    @Override
    public Instance getNextInstance() {
        if (this.instanceIterator.hasNext()) {
            return this.instanceIterator.next();
        }
        return null;
    }

    @Override
    public ArrayList<Instance> getAllInstances() {
        return new ArrayList<Instance>(this.instanceMap.values());
    }

    @Override
    public void addInstance(Instance i) {
        if (!this.instanceMap.containsKey(i.getUri())) {
            this.instanceMap.put(i.getUri(), i);
        }
    }

    @Override
    public Instance getInstance(String uri) {
        if (this.instanceMap.containsKey(uri)) {
            return this.instanceMap.get(uri);
        }
        return null;
    }

    @Override
    public int size() {
        return this.instanceMap.size();
    }

    @Override
    public void addTriple(String s, String p, String o) {
        if (this.instanceMap.containsKey(s)) {
            Instance m = this.instanceMap.get(s);
            m.addProperty(p, o);
        } else {
            Instance m = new Instance(s);
            m.addProperty(p, o);
            this.instanceMap.put(s, m);
        }
    }

    @Override
    public boolean containsInstance(Instance i) {
        return this.instanceMap.containsKey(i.getUri());
    }

    @Override
    public boolean containsUri(String uri) {
        return this.instanceMap.containsKey(uri);
    }

    @Override
    public void resetIterator() {
        this.instanceIterator = this.instanceMap.values().iterator();
    }

    public String toString() {
        return this.instanceMap.toString();
    }

    @Override
    public ArrayList<String> getAllUris() {
        return new ArrayList<String>(this.instanceMap.keySet());
    }

    @Override
    public ACache getSample(int size) {
        MemoryCache c = new MemoryCache();
        ArrayList<String> uris = this.getAllUris();
        while (((ACache)c).size() < size) {
            int index = (int)Math.floor(Math.random() * (double)this.size());
            Instance i = this.getInstance(uris.get(index));
            ((ACache)c).addInstance(i);
        }
        return c;
    }

    @Override
    public ACache processData(Map<String, String> propertyMap) {
        MemoryCache c = new MemoryCache();
        for (Instance instance : this.getAllInstances()) {
            String uri = instance.getUri();
            for (String p : instance.getAllProperties()) {
                for (String value : instance.getProperty(p)) {
                    if (propertyMap.containsKey(p)) {
                        ((ACache)c).addTriple(uri, p, Preprocessor.process(value, propertyMap.get(p)));
                        continue;
                    }
                    ((ACache)c).addTriple(uri, p, value);
                }
            }
        }
        return c;
    }

    @Override
    public ACache addProperty(String sourcePropertyName, String targetPropertyName, String processingChain) {
        MemoryCache c = new MemoryCache();
        for (Instance instance : this.getAllInstances()) {
            String uri = instance.getUri();
            for (String p : instance.getAllProperties()) {
                for (String value : instance.getProperty(p)) {
                    if (p.equals(sourcePropertyName)) {
                        ((ACache)c).addTriple(uri, targetPropertyName, Preprocessor.process(value, processingChain));
                        ((ACache)c).addTriple(uri, p, value);
                        continue;
                    }
                    ((ACache)c).addTriple(uri, p, value);
                }
            }
        }
        logger.debug("Cache is ready");
        return c;
    }

    @Override
    public Set<String> getAllProperties() {
        logger.debug("Get all properties...");
        if (this.size() > 0) {
            HashSet<String> props = new HashSet<String>();
            MemoryCache c = this;
            for (Instance i : ((ACache)c).getAllInstances()) {
                props.addAll(i.getAllProperties());
            }
            return props;
        }
        return new HashSet<String>();
    }

    @Override
    public void replaceInstance(String uri, Instance a) {
        if (this.instanceMap.containsKey(uri)) {
            this.instanceMap.remove(uri);
        }
        this.instanceMap.put(uri, a);
    }

    @Override
    public Model parseCSVtoRDFModel(String baseURI, String IDbaseURI, String rdfType) {
        if (baseURI.length() > 0 && !baseURI.endsWith("#") && !baseURI.endsWith("/")) {
            baseURI = baseURI + "#";
        }
        Model model = ModelFactory.createDefaultModel();
        Resource r_rdfType = model.createResource(baseURI + rdfType);
        Set<String> props = this.getAllProperties();
        HashMap<String, Property> map = new HashMap<String, Property>();
        for (String prop : props) {
            map.put(prop, model.createProperty(baseURI + prop));
        }
        Instance i = this.getNextInstance();
        while (i != null) {
            String uri = IDbaseURI + i.getUri();
            Resource r = model.createResource(uri);
            Statement typeStmt = model.createStatement(r, RDF.type, (RDFNode)r_rdfType);
            model.add(typeStmt);
            logger.debug("Created statement: " + typeStmt);
            props = i.getAllProperties();
            for (String prop : props) {
                for (String value : i.getProperty(prop)) {
                    Literal lit = model.createLiteral(value);
                    Statement stmt = model.createStatement(r, (Property)map.get(prop), (RDFNode)lit);
                    logger.debug("Created statement: " + stmt);
                    model.add(stmt);
                }
            }
            i = this.getNextInstance();
        }
        return model;
    }
}

