/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.plan;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instruction {
    static Logger logger = LoggerFactory.getLogger(Instruction.class);
    private Command command;
    private String measureExpression;
    private String threshold;
    private String mainThreshold = null;
    private int sourceIndex;
    private int targetIndex;
    private int resultIndex;

    public Instruction(Command c, String measure, String thrs, int source, int target, int result) {
        this.command = c;
        this.measureExpression = measure;
        this.threshold = thrs;
        this.sourceIndex = source;
        this.targetIndex = target;
        this.resultIndex = result;
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    public void setResultIndex(int resultIndex) {
        this.resultIndex = resultIndex;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public String getMeasureExpression() {
        return this.measureExpression;
    }

    public void setMeasureExpression(String measureExpression) {
        this.measureExpression = measureExpression;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public void setSourceIndex(int resourceIndex) {
        this.sourceIndex = resourceIndex;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public void setTargetIndex(int targetIndex) {
        this.targetIndex = targetIndex;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public String getMainThreshold() {
        return this.mainThreshold;
    }

    public void setMainThreshold(String threshold) {
        this.mainThreshold = threshold;
    }

    public boolean equals(Object other) {
        Instruction i = (Instruction)other;
        if (i == null) {
            return false;
        }
        if (this.mainThreshold == null && i.getMainThreshold() == null) {
            return this.toSmallString().equals(((Instruction)other).toSmallString());
        }
        if (this.mainThreshold != null && i.getMainThreshold() == null) {
            return false;
        }
        if (this.mainThreshold == null && i.getMainThreshold() != null) {
            return false;
        }
        if (this.mainThreshold.equals(i.getMainThreshold())) {
            return this.toSmallString().equals(((Instruction)other).toSmallString());
        }
        return false;
    }

    private String toSmallString() {
        String s = "";
        if (this.command.equals((Object)Command.RUN)) {
            s = "RUN\t";
        } else if (this.command.equals((Object)Command.FILTER)) {
            s = "FILTER\t";
        } else if (this.command.equals((Object)Command.DIFF)) {
            s = "DIFF\t";
        } else if (this.command.equals((Object)Command.INTERSECTION)) {
            s = "INTERSECTION\t";
        } else if (this.command.equals((Object)Command.UNION)) {
            s = "UNION\t";
        } else if (this.command.equals((Object)Command.XOR)) {
            s = "XOR\t";
        } else if (this.command.equals((Object)Command.REVERSEFILTER)) {
            s = "REVERSEFILTER\t";
        }
        s = s + this.measureExpression + "\t";
        s = s + this.threshold + "\t";
        return s;
    }

    public Instruction clone() {
        Command command = this.command;
        int sourceMapping = this.sourceIndex;
        int targetMapping = this.targetIndex;
        int resultIndex = this.resultIndex;
        Instruction newInstruction = new Instruction(command, "", "", sourceMapping, targetMapping, resultIndex);
        if (this.mainThreshold == null) {
            newInstruction.setMainThreshold(null);
        } else {
            newInstruction.setMainThreshold(new String(this.mainThreshold));
        }
        if (this.threshold == null) {
            newInstruction.setThreshold(null);
        } else {
            newInstruction.setThreshold(new String(this.threshold));
        }
        if (this.measureExpression == null) {
            newInstruction.setMeasureExpression(null);
        } else {
            newInstruction.setMeasureExpression(new String(this.measureExpression));
        }
        return newInstruction;
    }

    public String toString() {
        String s = "";
        if (this.command.equals((Object)Command.RUN)) {
            s = "RUN\t";
        } else if (this.command.equals((Object)Command.FILTER)) {
            s = "FILTER\t";
        } else if (this.command.equals((Object)Command.DIFF)) {
            s = "DIFF\t";
        } else if (this.command.equals((Object)Command.INTERSECTION)) {
            s = "INTERSECTION\t";
        } else if (this.command.equals((Object)Command.UNION)) {
            s = "UNION\t";
        } else if (this.command.equals((Object)Command.XOR)) {
            s = "XOR\t";
        } else if (this.command.equals((Object)Command.REVERSEFILTER)) {
            s = "REVERSEFILTER\t";
        }
        s = s + this.measureExpression + "\t";
        s = s + this.threshold + "\t";
        s = s + this.sourceIndex + "\t";
        s = s + this.targetIndex + "\t";
        s = s + this.resultIndex;
        return s;
    }

    public static enum Command {
        RUN,
        INTERSECTION,
        UNION,
        DIFF,
        RETURN,
        FILTER,
        XOR,
        REVERSEFILTER;

    }
}

