/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.APseudoPRF;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoPrecision
extends APseudoPRF {
    static Logger logger = LoggerFactory.getLogger(PseudoPrecision.class);

    public PseudoPrecision() {
    }

    public PseudoPrecision(boolean symmetricPrecision) {
        this();
        this.setSymmetricPrecision(symmetricPrecision);
    }

    @Override
    public double calculate(AMapping predictions, GoldStandard goldStandard) {
        AMapping res = predictions;
        AMapping rev = res.reverseSourceTarget();
        if (this.useOneToOneMapping) {
            res = predictions.getBestOneToNMapping();
            rev = res.reverseSourceTarget().getBestOneToNMapping();
        }
        double p = res.getMap().keySet().size();
        if (this.isSymmetricPrecision()) {
            p = res.getMap().keySet().size() + rev.getMap().keySet().size();
        }
        double q = 0.0;
        for (String s : predictions.getMap().keySet()) {
            if (this.isSymmetricPrecision()) {
                q += (double)(2 * predictions.getMap().get(s).size());
                continue;
            }
            q += (double)predictions.getMap().get(s).size();
        }
        if (p == 0.0 || q == 0.0) {
            return 0.0;
        }
        return p / q;
    }
}

