/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.aksw.limes.core.datastrutures.EvaluationRun;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.datastrutures.TaskAlgorithm;
import org.aksw.limes.core.datastrutures.TaskData;
import org.aksw.limes.core.evaluation.evaluationDataLoader.EvaluationData;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.evaluation.evaluator.FoldData;
import org.aksw.limes.core.evaluation.qualititativeMeasures.QualitativeMeasuresEvaluator;
import org.aksw.limes.core.evaluation.quantitativeMeasures.IQuantitativeMeasure;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.HybridCache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.MappingOperations;
import org.aksw.limes.core.ml.algorithm.AMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.ActiveMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.SupervisedMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.UnsupervisedMLAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluator {
    static Logger logger = LoggerFactory.getLogger(Evaluator.class);
    List<EvaluationRun> runsList = new ArrayList<EvaluationRun>();
    private QualitativeMeasuresEvaluator eval = new QualitativeMeasuresEvaluator();

    public List<EvaluationRun> evaluate(List<TaskAlgorithm> TaskAlgorithms, Set<TaskData> datasets, Set<EvaluatorType> QlMeasures, Set<IQuantitativeMeasure> QnMeasures) {
        AMapping predictions = null;
        Map<EvaluatorType, Double> evaluationResults = null;
        try {
            for (TaskAlgorithm tAlgorithm : TaskAlgorithms) {
                logger.info("Running algorihm: " + tAlgorithm.getMlAlgorithm().getName());
                for (TaskData dataset : datasets) {
                    AMLAlgorithm sml;
                    logger.info("Used dataset: " + dataset.dataName);
                    tAlgorithm.getMlAlgorithm().init(null, dataset.source, dataset.target);
                    MLResults mlModel = null;
                    if (tAlgorithm.getMlType().equals((Object)MLImplementationType.SUPERVISED_BATCH)) {
                        logger.info("Implementation type: " + (Object)((Object)MLImplementationType.SUPERVISED_BATCH));
                        sml = (SupervisedMLAlgorithm)tAlgorithm.getMlAlgorithm();
                        mlModel = ((SupervisedMLAlgorithm)sml).learn(dataset.training);
                    } else if (tAlgorithm.getMlType().equals((Object)MLImplementationType.SUPERVISED_ACTIVE)) {
                        logger.info("Implementation type: " + (Object)((Object)MLImplementationType.SUPERVISED_ACTIVE));
                        sml = (ActiveMLAlgorithm)tAlgorithm.getMlAlgorithm();
                        sml.getMl().setConfiguration(dataset.evalData.getConfigReader().getConfiguration());
                        ((ActiveMLAlgorithm)sml).activeLearn();
                        AMapping nextExamples = ((ActiveMLAlgorithm)sml).getNextExamples((int)Math.round(0.5 * (double)dataset.training.size()));
                        AMapping oracleFeedback = this.oracleFeedback(nextExamples, dataset.training);
                        mlModel = ((ActiveMLAlgorithm)sml).activeLearn(oracleFeedback);
                    } else if (tAlgorithm.getMlType().equals((Object)MLImplementationType.UNSUPERVISED)) {
                        logger.info("Implementation type: " + (Object)((Object)MLImplementationType.UNSUPERVISED));
                        sml = (UnsupervisedMLAlgorithm)tAlgorithm.getMlAlgorithm();
                        mlModel = ((UnsupervisedMLAlgorithm)sml).learn(dataset.pseudoFMeasure);
                    }
                    predictions = tAlgorithm.getMlAlgorithm().predict(dataset.source, dataset.target, mlModel);
                    logger.info("Start the evaluation of the results");
                    evaluationResults = this.eval.evaluate(predictions, dataset.goldStandard, QlMeasures);
                    EvaluationRun er = new EvaluationRun(tAlgorithm.getMlAlgorithm().getName().replaceAll("\\s+", ""), tAlgorithm.getMlType().name().replaceAll("//s", ""), dataset.dataName.replaceAll("//s", ""), evaluationResults);
                    this.runsList.add(er);
                }
            }
        }
        catch (UnsupportedMLImplementationException e) {
            e.printStackTrace();
        }
        return this.runsList;
    }

    public List<EvaluationRun> crossValidate(AMLAlgorithm algorithm, List<LearningParameter> parameter, Set<TaskData> datasets, int foldNumber, Set<EvaluatorType> qlMeasures, Set<IQuantitativeMeasure> qnMeasures) {
        for (TaskData dataset : datasets) {
            List<FoldData> folds = this.generateFolds(dataset.evalData, foldNumber);
            FoldData trainData = new FoldData();
            FoldData testData = folds.get(foldNumber - 1);
            for (int i = 0; i < foldNumber; ++i) {
                if (i == 9) continue;
                trainData.map = MappingOperations.union(trainData.map, folds.get((int)i).map);
                trainData.sourceCache = this.cacheUnion(trainData.sourceCache, folds.get((int)i).sourceCache);
                trainData.targetCache = this.cacheUnion(trainData.targetCache, folds.get((int)i).targetCache);
            }
            for (String s : trainData.map.getMap().keySet()) {
                for (String t : trainData.map.getMap().get(s).keySet()) {
                    if (trainData.targetCache.containsUri(t)) continue;
                    trainData.targetCache.addInstance(dataset.target.getInstance(t));
                }
                if (trainData.sourceCache.containsUri(s)) continue;
                trainData.sourceCache.addInstance(dataset.source.getInstance(s));
            }
            AMapping trainingData = trainData.map;
            ACache trainSourceCache = trainData.sourceCache;
            ACache trainTargetCache = trainData.targetCache;
            ACache testSourceCache = testData.sourceCache;
            ACache testTargetCache = testData.targetCache;
            GoldStandard goldStandard = new GoldStandard(testData.map, testSourceCache.getAllUris(), testTargetCache.getAllUris());
            algorithm.init(parameter, trainSourceCache, trainTargetCache);
            Configuration config = dataset.evalData.getConfigReader().read();
            algorithm.getMl().setConfiguration(config);
            MLResults model = null;
            try {
                if (algorithm instanceof SupervisedMLAlgorithm) {
                    model = algorithm.asSupervised().learn(trainingData);
                } else if (algorithm instanceof ActiveMLAlgorithm) {
                    model = algorithm.asActive().activeLearn(trainingData);
                }
            }
            catch (UnsupportedMLImplementationException e) {
                e.printStackTrace();
            }
            EvaluationRun er = new EvaluationRun(algorithm.getName(), dataset.dataName, this.eval.evaluate(algorithm.predict(testSourceCache, testTargetCache, model), goldStandard, qlMeasures));
            er.display();
            this.runsList.add(er);
        }
        return this.runsList;
    }

    public ACache cacheUnion(ACache a, ACache b) {
        HybridCache result = new HybridCache();
        for (Instance i : a.getAllInstances()) {
            ((ACache)result).addInstance(i);
        }
        for (Instance i : b.getAllInstances()) {
            ((ACache)result).addInstance(i);
        }
        return result;
    }

    public List<FoldData> generateFolds(EvaluationData data, int foldNumber) {
        ArrayList<FoldData> folds = new ArrayList<FoldData>();
        ACache source = data.getSourceCache();
        ACache target = data.getTargetCache();
        AMapping refMap = data.getReferenceMapping();
        refMap = this.removeLinksWithNoInstances(refMap, source, target);
        List<AMapping> foldMaps = this.generateMappingFolds(refMap, source, target, foldNumber);
        for (AMapping foldMap : foldMaps) {
            HybridCache sourceFoldCache = new HybridCache();
            HybridCache targetFoldCache = new HybridCache();
            for (String s : foldMap.getMap().keySet()) {
                if (!source.containsUri(s)) continue;
                ((ACache)sourceFoldCache).addInstance(source.getInstance(s));
                for (String t : foldMap.getMap().get(s).keySet()) {
                    if (!target.containsUri(t)) continue;
                    ((ACache)targetFoldCache).addInstance(target.getInstance(t));
                }
            }
            folds.add(new FoldData(foldMap, sourceFoldCache, targetFoldCache));
        }
        return folds;
    }

    public List<AMapping> generateMappingFolds(AMapping refMap, ACache source, ACache target, int foldNumber) {
        Random rand = new Random();
        ArrayList<AMapping> foldMaps = new ArrayList<AMapping>();
        int mapSize = refMap.getMap().keySet().size();
        int foldSize = mapSize / foldNumber;
        Iterator<HashMap<String, Double>> it = refMap.getMap().values().iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (it.hasNext()) {
            for (String t : it.next().keySet()) {
                values.add(t);
            }
        }
        for (int foldIndex = 0; foldIndex < foldNumber; ++foldIndex) {
            HashSet<Integer> index = new HashSet<Integer>();
            while (index.size() < foldSize) {
                int number;
                while (index.contains(number = (int)((double)mapSize * Math.random()))) {
                }
                index.add(number);
            }
            AMapping foldMap = MappingFactory.createDefaultMapping();
            int count = 0;
            for (String key : refMap.getMap().keySet()) {
                HashMap<String, Double> help;
                if (foldIndex != foldNumber - 1) {
                    if (index.contains(count) && count % 2 == 0) {
                        help = new HashMap();
                        for (String k : refMap.getMap().get(key).keySet()) {
                            help.put(k, 1.0);
                        }
                        foldMap.getMap().put(key, help);
                    } else if (index.contains(count)) {
                        help = new HashMap();
                        help.put(Evaluator.getRandomTargetInstance(source, target, values, rand, refMap.getMap(), key, -1), 0.0);
                        foldMap.getMap().put(key, help);
                    }
                } else if (index.contains(count)) {
                    help = new HashMap<String, Double>();
                    for (String k : refMap.getMap().get(key).keySet()) {
                        help.put(k, 1.0);
                    }
                    foldMap.getMap().put(key, help);
                }
                ++count;
            }
            foldMaps.add(foldMap);
            refMap = this.removeSubMap(refMap, foldMap);
        }
        int i = 0;
        int odd = 0;
        for (String key : refMap.getMap().keySet()) {
            HashMap<String, Double> help;
            if (i != foldNumber - 1) {
                if (odd % 2 == 0) {
                    help = new HashMap();
                    for (String k : refMap.getMap().get(key).keySet()) {
                        help.put(k, 1.0);
                    }
                    ((AMapping)foldMaps.get(i)).add(key, help);
                } else {
                    help = new HashMap();
                    help.put(Evaluator.getRandomTargetInstance(source, target, values, rand, refMap.getMap(), key, -1), 0.0);
                    ((AMapping)foldMaps.get(i)).add(key, help);
                }
            } else {
                help = new HashMap<String, Double>();
                for (String k : refMap.getMap().get(key).keySet()) {
                    help.put(k, 1.0);
                }
                ((AMapping)foldMaps.get(i)).add(key, help);
            }
            ++odd;
            i = (i + 1) % foldNumber;
        }
        return foldMaps;
    }

    public static String getRandomTargetInstance(ACache source, ACache target, List<String> values, Random random, HashMap<String, HashMap<String, Double>> refMap, String sourceInstance, int previousRandom) {
        int randomInt;
        while ((randomInt = random.nextInt(values.size())) == previousRandom) {
        }
        String tmpTarget = values.get(randomInt);
        if (refMap.get(sourceInstance).get(tmpTarget) == null && target.getInstance(tmpTarget) != null) {
            return tmpTarget;
        }
        return Evaluator.getRandomTargetInstance(source, target, values, random, refMap, sourceInstance, randomInt);
    }

    public AMapping removeSubMap(AMapping mainMap, AMapping subMap) {
        AMapping result = MappingFactory.createDefaultMapping();
        double value = 0.0;
        for (String mainMapSourceUri : mainMap.getMap().keySet()) {
            for (String mainMapTargetUri : mainMap.getMap().get(mainMapSourceUri).keySet()) {
                if (subMap.contains(mainMapSourceUri, mainMapTargetUri)) continue;
                result.add(mainMapSourceUri, mainMapTargetUri, value);
            }
        }
        return result;
    }

    private AMapping removeLinksWithNoInstances(AMapping map, ACache source, ACache target) {
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : map.getMap().keySet()) {
            for (String t : map.getMap().get(s).keySet()) {
                if (!source.containsUri(s) || !target.containsUri(t)) continue;
                result.add(s, t, map.getMap().get(s).get(t));
            }
        }
        return result;
    }

    private AMapping oracleFeedback(AMapping predictionMapping, AMapping referenceMapping) {
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : predictionMapping.getMap().keySet()) {
            for (String t : predictionMapping.getMap().get(s).keySet()) {
                if (referenceMapping.contains(s, t)) {
                    result.add(s, t, 1.0);
                    continue;
                }
                result.add(s, t, 0.0);
            }
        }
        return result;
    }
}

