/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluationDataLoader;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.config.reader.rdf.RDFConfigurationReader;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropMapper {
    static Logger logger = LoggerFactory.getLogger(PropMapper.class);

    public static PropertyMapping getPropertyMapping(String configFile) {
        RDFConfigurationReader cR = new RDFConfigurationReader(configFile);
        ((AConfigurationReader)cR).read();
        return PropMapper.getPropertyMapping(cR, configFile);
    }

    public static PropertyMapping getPropertyMapping(AConfigurationReader cR, String name) {
        PropertyMapping pM = new PropertyMapping();
        if (!name.substring(name.lastIndexOf("/") + 1).startsWith("dbpedia-linkedmdb") && !name.substring(name.lastIndexOf("/") + 1).startsWith("dailymed-drugbank")) {
            int max = Math.max(cR.getConfiguration().getSourceInfo().getProperties().size(), cR.getConfiguration().getTargetInfo().getProperties().size()) - 1;
            for (int i = 0; i < max; ++i) {
                pM.addStringPropertyMatch(cR.getConfiguration().getSourceInfo().getProperties().get(i), cR.getConfiguration().getTargetInfo().getProperties().get(i));
            }
            pM.addDatePropertyMatch(cR.getConfiguration().getSourceInfo().getProperties().get(max), cR.getConfiguration().getTargetInfo().getProperties().get(max));
        } else {
            int max = Math.max(cR.getConfiguration().getSourceInfo().getProperties().size(), cR.getConfiguration().getTargetInfo().getProperties().size() - 1);
            for (int i = 0; i < max; ++i) {
                pM.addStringPropertyMatch(cR.getConfiguration().getSourceInfo().getProperties().get(i), cR.getConfiguration().getTargetInfo().getProperties().get(i));
            }
        }
        System.out.println("PM: " + pM);
        return pM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyMapping getPropertyMappingFromFile(String folder, String name) {
        if (name.indexOf("/") > 0) {
            name = name.substring(name.lastIndexOf("/"));
        }
        String filename = name.substring(0, name.lastIndexOf("."));
        filename = filename + "propertymatch";
        PropertyMapping pM = new PropertyMapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(folder + filename));
            String s = reader.readLine();
            while (s != null && s.length() > 0) {
                String[] split = s.split("\t");
                if (split[2].equalsIgnoreCase("number")) {
                    pM.addNumberPropertyMatch(split[0], split[1]);
                }
                if (split[2].equalsIgnoreCase("string")) {
                    pM.addStringPropertyMatch(split[0], split[1]);
                }
                if (split[2].equalsIgnoreCase("date")) {
                    pM.addDatePropertyMatch(split[0], split[1]);
                }
                if (split[2].equalsIgnoreCase("pointset")) {
                    pM.addPointsetPropertyMatch(split[0], split[1]);
                }
                s = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return pM;
        }
    }
}

