/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.datastrutures;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.evaluation.quantitativeMeasures.RunRecord;
import org.aksw.limes.core.io.ls.LinkSpecification;

public class EvaluationRun {
    private final int stringSize = 200;
    private String algorithmName = "";
    private String implementationType = "";
    private String datasetName = "";
    public Map<EvaluatorType, Double> qualititativeScores = new HashMap<EvaluatorType, Double>();
    RunRecord quanititativeRecord = new RunRecord();
    private LinkSpecification learnedLS;

    public EvaluationRun() {
    }

    public EvaluationRun(String algorithmName, String datasetName, Map<EvaluatorType, Double> evaluatorsScores) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
    }

    public EvaluationRun(String algorithmName, String implementation, String datasetName, Map<EvaluatorType, Double> evaluatorsScores) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        this.implementationType = implementation;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
    }

    public EvaluationRun(String algorithmName, String implementation, String datasetName, Map<EvaluatorType, Double> evaluatorsScores, LinkSpecification learnedLS) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        this.implementationType = implementation;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
        this.learnedLS = learnedLS;
    }

    public EvaluationRun(String algorithmName, String datasetName, Map<EvaluatorType, Double> evaluatorsScores, RunRecord quantitativeRecord) {
        this.algorithmName = algorithmName;
        this.datasetName = datasetName;
        for (EvaluatorType evaluator : evaluatorsScores.keySet()) {
            this.qualititativeScores.put(evaluator, evaluatorsScores.get((Object)evaluator));
        }
        this.quanititativeRecord = quantitativeRecord;
    }

    public Set<EvaluatorType> getQualititativeMeasures() {
        return this.qualititativeScores.keySet();
    }

    public void display() {
        System.out.println("==================================================================================================================");
        System.out.println("ALGORITHM_NAME\tIMPLEMENTATION\tDATASET");
        System.out.println(this.getAlgorithmName() + "\t" + this.getImplementationType() + "\t" + this.getDatasetName());
        System.out.println("------------------------------------------------------------------------------------------------------------------");
        for (EvaluatorType evaluator : this.qualititativeScores.keySet()) {
            System.out.println((Object)((Object)evaluator) + "\t" + this.qualititativeScores.get((Object)evaluator));
        }
        if (this.learnedLS != null) {
            System.out.println("------------------------------------------------------------------------------------------------------------------");
            System.out.println(this.learnedLS);
        }
        System.out.println("==================================================================================================================");
    }

    public String toString() {
        String erString = this.Serialize(":");
        return erString + "\n";
    }

    public String Serialize(String separator) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getAlgorithmName());
        sb.append(separator);
        sb.append(this.getImplementationType());
        sb.append(separator);
        sb.append(this.getDatasetName());
        sb.append(separator);
        for (EvaluatorType evaluator : this.qualititativeScores.keySet()) {
            sb.append(this.qualititativeScores.get((Object)evaluator).toString());
            sb.append(separator);
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public String getDatasetName() {
        return this.datasetName;
    }
}

