/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Part;
import org.aksw.limes.core.controller.Controller;
import org.aksw.limes.core.controller.ResultMappings;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.serializer.ISerializer;
import org.aksw.limes.core.io.serializer.SerializerFactory;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String STORAGE_DIR_PATH = "./.server-storage/";
    public static final String LOG_DIR_PATH = "./.server-storage/logs/";
    public static final String CONFIG_FILE_PREFIX = "limes_cfg_";
    public static final String CONFIG_FILE_SUFFIX = "xml";
    private static final Gson GSON = new GsonBuilder().create();
    private static Server instance = null;
    private final Map<String, CompletableFuture<Void>> requests = new HashMap<String, CompletableFuture<Void>>();
    private final File uploadDir = new File("./.server-storage/");
    private int port = -1;
    private int limit = -1;

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    public void run(int port, int limit) {
        this.limit = limit;
        if (this.port > 0) {
            throw new IllegalStateException("Server already running on port " + port + "!");
        }
        this.port = port;
        if (!this.uploadDir.exists()) {
            this.uploadDir.mkdir();
        }
        Spark.port((int)port);
        Spark.staticFiles.location("/web-ui");
        Spark.staticFiles.expireTime(10L);
        Server.enableCORS("*", "GET, POST, OPTIONS", "");
        Spark.post((String)"/submit", this::handleSubmit);
        Spark.get((String)"/status/:id", this::handleStatus);
        Spark.get((String)"/logs/:id", this::handleLogs);
        Spark.get((String)"/results/:id", this::handleResults);
        Spark.get((String)"/result/:id/:file", this::handleResult);
        Spark.exception(Exception.class, (e, req, res) -> {
            logger.error("Error in processing request" + req.uri(), (Throwable)e);
            res.status(500);
            res.type("application/json");
            res.body(GSON.toJson((Object)new ErrorMessage(e)));
        });
        Spark.notFound((req, res) -> {
            res.type("application/json");
            res.status(404);
            return GSON.toJson((Object)new ErrorMessage(-2, "Route not known"));
        });
        Spark.init();
        Spark.awaitInitialization();
    }

    private Server() {
    }

    private Object handleSubmit(Request req, Response res) throws Exception {
        req.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement("/temp"));
        Part configFile = req.raw().getPart("config_file");
        String fileName = Server.getFileName(configFile);
        String suffix = FilenameUtils.getExtension((String)fileName);
        Path tempFile = Files.createTempFile(this.uploadDir.toPath(), CONFIG_FILE_PREFIX, "." + (suffix.equals("") ? CONFIG_FILE_SUFFIX : suffix), new FileAttribute[0]);
        try (InputStream is = configFile.getInputStream();){
            Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        logger.info("Uploaded file '{}' saved as '{}'", (Object)fileName, (Object)tempFile.toAbsolutePath());
        String id = tempFile.toString();
        id = id.substring(id.indexOf(CONFIG_FILE_PREFIX) + CONFIG_FILE_PREFIX.length(), id.lastIndexOf("."));
        File workingDir = new File(this.uploadDir.getAbsoluteFile(), id);
        if (!workingDir.mkdir()) {
            throw new RuntimeException("Not able to create directory " + workingDir.getAbsolutePath());
        }
        String requestId = id;
        this.requests.put(requestId, (CompletableFuture<Void>)((CompletableFuture)CompletableFuture.completedFuture(null).thenAcceptAsync($ -> {
            MDC.put((String)"requestId", (String)requestId);
            XMLConfigurationReader reader = new XMLConfigurationReader(tempFile.toAbsolutePath().toString());
            Configuration config = ((AConfigurationReader)reader).read();
            ResultMappings mappings = Controller.getMapping(config, this.limit);
            String outputFormat = config.getOutputFormat();
            ISerializer output = SerializerFactory.createSerializer(outputFormat);
            output.setPrefixes(config.getPrefixes());
            File verificationFile = new File(workingDir, config.getVerificationFile());
            File acceptanceFile = new File(workingDir, config.getAcceptanceFile());
            output.writeToFile(mappings.getVerificationMapping(), config.getVerificationRelation(), verificationFile.getAbsolutePath());
            output.writeToFile(mappings.getAcceptanceMapping(), config.getAcceptanceRelation(), acceptanceFile.getAbsolutePath());
        })).exceptionally(e -> {
            e.printStackTrace();
            return null;
        }));
        res.status(200);
        return GSON.toJson((Object)new SubmitMessage(id));
    }

    private Object handleStatus(Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        StatusMessage result = !this.requests.containsKey(id) ? new StatusMessage(-1, "Request ID not found") : (!this.requests.get(id).isDone() ? new StatusMessage(1, "Request is being processed") : new StatusMessage(2, "Request has been processed"));
        res.status(200);
        return GSON.toJson((Object)result);
    }

    private Object handleLogs(Request req, Response res) throws Exception {
        String id = Server.sanitizeId(req.params("id"));
        File requestedFile = new File(LOG_DIR_PATH + id + ".log");
        if (requestedFile.exists()) {
            boolean finish;
            res.type("text/plain");
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            boolean bl = finish = !this.requests.containsKey(id) || this.requests.get(id).isDone();
            while (true) {
                int count;
                if ((count = fs.read(buffer)) >= 0) {
                    os.write(buffer, 0, count);
                    continue;
                }
                os.flush();
                if (finish) break;
                Thread.sleep(500L);
                finish = this.requests.get(id).isDone();
            }
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Logfile not found"));
    }

    private Object handleResult(Request req, Response res) throws Exception {
        String id = Server.sanitizeId(req.params("id"));
        File file = new File(req.params("file"));
        File requestedFile = new File(STORAGE_DIR_PATH + id + "/" + file.getName());
        if (requestedFile.exists()) {
            int count;
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
            Collection mimeTypes = MimeUtil.getMimeTypes((File)requestedFile, (MimeType)new MimeType("text/plain"));
            res.type(mimeTypes.iterator().next().toString());
            res.header("Content-Disposition", "attachment; filename=" + file.getName());
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            while ((count = fs.read(buffer)) >= 0) {
                os.write(buffer, 0, count);
            }
            os.flush();
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Result file not found"));
    }

    private Object handleResults(Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        File dir = new File(STORAGE_DIR_PATH + id);
        if (dir.exists() && dir.isDirectory()) {
            List availableFiles = Arrays.stream((Object[])Objects.requireNonNull(dir.listFiles())).map(File::getName).collect(Collectors.toList());
            return GSON.toJson((Object)new ResultsMessage(availableFiles));
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Request ID not found"));
    }

    private static String sanitizeId(String id) {
        return id.replaceAll("[^\\d]", "");
    }

    private static String getFileName(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return "config.ttl";
    }

    private static void enableCORS(String origin, String methods, String headers) {
        Spark.options((String)"/*", (request, response) -> {
            String accessControlRequestMethod;
            String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null) {
                response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
            }
            if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
            }
            return "OK";
        });
        Spark.before((Filter[])new Filter[]{(request, response) -> {
            response.header("Access-Control-Allow-Origin", origin);
            response.header("Access-Control-Request-Method", methods);
            response.header("Access-Control-Allow-Headers", headers);
            response.type("application/json");
        }});
    }

    private static class SubmitMessage
    extends ServerMessage {
        private String requestId;

        private SubmitMessage(String requestId) {
            this.requestId = requestId;
        }
    }

    private static class ResultsMessage
    extends ServerMessage {
        private List<String> availableFiles;

        private ResultsMessage(List<String> availableFiles) {
            this.availableFiles = availableFiles;
        }
    }

    private static class StatusMessage
    extends ServerMessage {
        private Status status = new Status();

        private StatusMessage(int status, String description) {
            this.status.code = status;
            this.status.description = description;
        }

        private static class Status {
            int code;
            String description;

            private Status() {
            }
        }
    }

    private static class ErrorMessage
    extends ServerMessage {
        private Error error;

        ErrorMessage(Throwable e) {
            this(-1, e.getMessage());
        }

        ErrorMessage(int code, String message) {
            this.success = false;
            this.error = new Error();
            this.error.code = code;
            this.error.message = message;
        }

        private static class Error {
            private int code;
            private String message;

            private Error() {
            }
        }
    }

    private static class ServerMessage {
        protected boolean success = true;

        private ServerMessage() {
        }
    }
}

