package org.aksw.limes.core.preprocessing;

import org.aksw.limes.core.io.cache.ACache;

import java.util.function.Function;

/**
 * A Preprocessor will transform a given knowledge base before passing it to mappers.
 * Preprocessors should have a time complexity of at most O(n).
 * @author Kevin Dreßler
 */
public interface Preprocessor extends Function<ACache, ACache> {

    /**
     * This method implements the concrete pre-processing
     * @param cache Cache object to apply pre-processing to.
     * @return A copy of the cache given to the method with the preprocessing applied to it.
     */
    ACache apply(ACache cache);

}
